/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.mt;

import java.util.List;

import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;

public class TenantProviderServiceImpl extends ServiceDelegator implements TenantProviderService {

	public TenantProviderServiceImpl(String name) {
		super(name);
	}

	@Override
	public List<TenantInfo> readTenantsInfo() {
		ReadTenantsEventContext context = ReadTenantsEventContext.create();
		emit(context);
		return context.getResult();
	}

	@Override
	public String readProviderTenant() {
		ReadProviderTenantEventContext context = ReadProviderTenantEventContext.create();
		emit(context);
		return context.getResult();
	}
}
