/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.impl.ProxyList;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.CdsOptionalArguments;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TypedCqnServiceInvocationHandler
implements InvocationHandler {
    private final CqnService service;
    private final Map<Method, MethodInfo> methodInfos = new HashMap<Method, MethodInfo>();

    TypedCqnServiceInvocationHandler(CqnService service, Class<? extends CqnService> generatedInterface) {
        this.service = service;
        for (Method method : generatedInterface.getDeclaredMethods()) {
            String eventName = TypedCqnServiceInvocationHandler.getCdsName(method).orElse(method.getName());
            String entityName = null;
            Parameter[] parameters = method.getParameters();
            String[] argNames = new String[parameters.length];
            int optionalArgumentIndex = -1;
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (i == 0 && StructuredType.class.isAssignableFrom(parameter.getType())) {
                    argNames[i] = "cqn";
                    entityName = TypedCqnServiceInvocationHandler.getCdsName(parameter.getType()).orElse(null);
                    continue;
                }
                if (parameter.getAnnotation(CdsOptionalArguments.class) != null) {
                    optionalArgumentIndex = i;
                    continue;
                }
                argNames[i] = TypedCqnServiceInvocationHandler.getCdsName(parameter).orElse(parameter.getName());
            }
            this.methodInfos.put(method, new MethodInfo(eventName, entityName, argNames, optionalArgumentIndex));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInfo methodInfo = this.methodInfos.get(method);
        if (methodInfo != null) {
            EventContext eventContext = this.createEventContext(methodInfo, args);
            this.service.emit(eventContext);
            Object result = eventContext.get("result");
            return TypedCqnServiceInvocationHandler.transformResult(result, method);
        }
        try {
            return method.invoke((Object)this.service, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Service getDelegatedService() {
        return this.service;
    }

    private EventContext createEventContext(MethodInfo methodInfo, Object[] args) {
        EventContext eventContext = EventContext.create((String)methodInfo.event, (String)methodInfo.entity);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i == methodInfo.optionalArgumentIndex() && arg instanceof CdsData) {
                    CdsData data = (CdsData)arg;
                    data.forEach((arg_0, arg_1) -> ((EventContext)eventContext).put(arg_0, arg_1));
                    continue;
                }
                if (i == 0 && arg instanceof StructuredType) {
                    StructuredType structuredType = (StructuredType)arg;
                    arg = Select.from((StructuredType)structuredType);
                }
                eventContext.put(methodInfo.argNames[i], arg);
            }
        }
        return eventContext;
    }

    static Optional<String> getCdsName(AnnotatedElement annotated) {
        CdsName cdsName = annotated.getAnnotation(CdsName.class);
        if (cdsName != null && !StringUtils.isEmpty((String)cdsName.value())) {
            return Optional.of(cdsName.value());
        }
        return Optional.empty();
    }

    private static Object transformResult(Object result, Method method) {
        if (result == null) {
            return result;
        }
        Class<?> returnType = method.getReturnType();
        if (Map.class.isAssignableFrom(returnType)) {
            if (result.getClass().isAssignableFrom(returnType) || Map.class == returnType) {
                return result;
            }
            return Struct.access((Map)((Map)result)).as(returnType);
        }
        if (Collection.class.isAssignableFrom(returnType)) {
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                Class itemClass;
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type type = parameterizedType.getActualTypeArguments()[0];
                if (type instanceof Class && Map.class.isAssignableFrom(itemClass = (Class)type) && Map.class != itemClass) {
                    return new ProxyList((List)result, itemClass);
                }
                return result;
            }
            throw new IllegalStateException("Return type of service interface method " + method.getName() + " must be parameterized");
        }
        return result;
    }

    private record MethodInfo(String event, String entity, String[] argNames, int optionalArgumentIndex) {
    }
}

