/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean isParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ReflectionUtils.isParameterizedType(wildcardType.getUpperBounds()[0]);
        }
        return false;
    }

    public static ParameterizedType getParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ReflectionUtils.getParameterizedType(wildcardType.getUpperBounds()[0]);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_TYPE, new Object[]{type.getTypeName()});
    }

    public static Class<?> getClassForType(Type type) throws ClassNotFoundException {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ReflectionUtils.getClassForType(wildcardType.getUpperBounds()[0]);
        }
        if (type instanceof Class) {
            Class class1 = (Class)type;
            return Class.forName(type.getTypeName(), true, class1.getClassLoader());
        }
        return Class.forName(type.getTypeName());
    }
}

