/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.PathExpressionPredicateConverter;
import com.sap.cds.services.impl.authorization.ReadStatementAuthorizationModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CqnStatementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class InstanceBasedAuthorizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceBasedAuthorizationHandler.class);
    private final boolean authorizeDeeply;
    private final boolean regardCustomEvents;
    private final boolean checkInputData;

    public InstanceBasedAuthorizationHandler(CdsRuntime runtime) {
        CdsProperties.Security.Authorization authorization = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthorization();
        this.authorizeDeeply = authorization.getDeep().isEnabled();
        this.regardCustomEvents = authorization.getInstanceBased().getCustomEvents().isEnabled();
        this.checkInputData = authorization.getInstanceBased().getCheckInputData().isEnabled();
    }

    @Before(event={"*"})
    @HandlerOrder(value=-10600)
    private void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged()) {
            this.extendStatements(context);
        }
    }

    private boolean isRelevantEvent(String eventName, String entityName) {
        return eventName.equals("DELETE") || eventName.equals("UPDATE") || eventName.equals("draftEdit") || eventName.equals("draftActivate") || this.regardCustomEvents && !CdsModelUtils.isStandardCdsEvent(eventName) && entityName != null;
    }

    private void extendStatements(EventContext context) {
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        String event = context.getEvent();
        String serviceName = ((ApplicationService)context.getService()).getDefinition().getQualifiedName();
        CdsEntity targetEntity = context.getTarget();
        String targetEntityName = null;
        if (targetEntity != null) {
            targetEntityName = targetEntity.getQualifiedName();
        }
        if (event.equals("READ")) {
            CdsReadEventContext cdsContext = (CdsReadEventContext)context.as(CdsReadEventContext.class);
            if (this.authorizeDeeply) {
                CqnSelect secured = (CqnSelect)CQL.copy((CqnStatement)cdsContext.getCqn(), (Modifier)new ReadStatementAuthorizationModifier(authService, cdsContext));
                if (logger.isDebugEnabled()) {
                    logger.debug("Statement is extended with security conditions for target '{}' of service '{}': '{}'", new Object[]{targetEntityName, serviceName, CqnStatementUtils.anonymizeStatement((CqnStatement)secured)});
                }
                cdsContext.setCqn(secured);
            } else {
                CqnSelect select = cdsContext.getCqn();
                CqnPredicate whereCondition = this.adaptWhereConditionForDraftIfNecessary(authService, event, targetEntity, false);
                if (whereCondition != null) {
                    select = (CqnSelect)CqnUtils.addWhere((CqnStatement)select, (CqnPredicate)whereCondition);
                }
                cdsContext.setCqn(select);
            }
        } else if (this.isRelevantEvent(event, targetEntityName)) {
            CqnPredicate whereCondition = this.adaptWhereConditionForDraftIfNecessary(authService, event, targetEntity, true);
            if (whereCondition != null) {
                Object object = context.get("cqn");
                if (object instanceof CqnFilterableStatement) {
                    CqnFilterableStatement cqn = (CqnFilterableStatement)object;
                    context.put("cqn", (Object)CqnUtils.addWhere((CqnStatement)cqn, (CqnPredicate)whereCondition));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{whereCondition.toJson(), targetEntityName, serviceName, event, context.getUserInfo().getName()});
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("No CQN authorization predicate required for entity '{}' of service '{}', event {} and user {}", new Object[]{targetEntityName, serviceName, event, context.getUserInfo().getName()});
            }
        }
        logger.debug("Instance-based authorization check passed for event '{}' on service '{}'", (Object)event, (Object)serviceName);
    }

    private CqnPredicate adaptWhereConditionForDraftIfNecessary(AuthorizationService authService, String eventName, CdsEntity targetEntity, boolean rewritePath) {
        boolean relaxInactive;
        if (targetEntity == null) {
            return authService.calcWhereCondition(null, eventName);
        }
        CqnPredicate whereCondition = authService.calcWhereCondition(targetEntity.getQualifiedName(), eventName);
        if (whereCondition == null) {
            return null;
        }
        if (rewritePath) {
            whereCondition = PathExpressionPredicateConverter.convert((CdsStructuredType)targetEntity, whereCondition);
        }
        boolean bl = relaxInactive = this.checkInputData || !"draftActivate".equals(eventName);
        if (relaxInactive && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
            return CQL.or((CqnPredicate)whereCondition, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
        }
        return whereCondition;
    }
}

