/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.services.impl.utils.CombinedMap;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class ModifiedValues {
    private final Map<String, Object> modifiedValues = new TreeMap<String, Object>();

    public <T> Property<T> field(String name, Supplier<T> prevValue) {
        return new PropertyImpl<T>(name, prevValue);
    }

    public <K, V> MapProperty<K, V> field(String name, Supplier<Map<K, V>> prevValue, Function<K, V> prevMapValue) {
        return new MapPropertyImpl<K, V>(name, prevValue, prevMapValue);
    }

    public <K, V> MapProperty<K, V> field(String name, Supplier<Map<K, V>> prevValue, Function<K, V> prevMapValue, Comparator<K> comparator) {
        return new MapPropertyImpl<K, V>(name, prevValue, prevMapValue, comparator);
    }

    class PropertyImpl<T>
    implements Property<T> {
        final String name;
        final Supplier<T> prevValue;

        PropertyImpl(String name, Supplier<T> prevValue) {
            this.name = name;
            this.prevValue = prevValue;
        }

        @Override
        public T getValue() {
            if (this.isModified()) {
                return this.getModifiedValue();
            }
            return this.prevValue.get();
        }

        @Override
        public T getModifiedValue() {
            return (T)ModifiedValues.this.modifiedValues.get(this.name);
        }

        @Override
        public boolean isModified() {
            return ModifiedValues.this.modifiedValues.containsKey(this.name);
        }

        @Override
        public void modifyValue(T value) {
            ModifiedValues.this.modifiedValues.put(this.name, value);
        }
    }

    class MapPropertyImpl<K, V>
    implements MapProperty<K, V> {
        final String name;
        final Supplier<Map<K, V>> prevValue;
        final Function<K, V> prevMapValue;
        final Comparator<K> comparator;
        boolean overridden;

        MapPropertyImpl(String name, Supplier<Map<K, V>> prevValue, Function<K, V> prevMapValue) {
            this(name, prevValue, prevMapValue, null);
        }

        MapPropertyImpl(String name, Supplier<Map<K, V>> prevValue, Function<K, V> prevMapValue, Comparator<K> comparator) {
            this.name = name;
            this.prevValue = prevValue;
            this.prevMapValue = prevMapValue;
            this.comparator = comparator;
        }

        @Override
        public V getMapValue(K key) {
            Object modified = this.getModifiedValue();
            if (modified != null && modified.containsKey(key)) {
                return modified.get(key);
            }
            if (this.overridden) {
                return null;
            }
            return this.prevMapValue.apply(key);
        }

        @Override
        public void modifyMapValue(K key, V value) {
            HashMap<K, V> modified = this.getModifiedValue();
            if (modified == null) {
                modified = this.comparator == null ? new HashMap() : new TreeMap(this.comparator);
                ModifiedValues.this.modifiedValues.put(this.name, modified);
            }
            modified.put(key, value);
        }

        @Override
        public Map<K, V> getValue() {
            Map<K, V> prevMapValue;
            AbstractMap modifiedMapValue = this.getModifiedValue();
            if (this.overridden) {
                return modifiedMapValue;
            }
            if (modifiedMapValue == null) {
                modifiedMapValue = this.comparator == null ? new HashMap() : new TreeMap(this.comparator);
                ModifiedValues.this.modifiedValues.put(this.name, modifiedMapValue);
            }
            if ((prevMapValue = this.prevValue.get()) == null) {
                return modifiedMapValue;
            }
            return new CombinedMap(modifiedMapValue, prevMapValue);
        }

        @Override
        public void modifyValue(Map<K, V> mapValue) {
            ModifiedValues.this.modifiedValues.put(this.name, mapValue);
            this.overridden = true;
        }

        @Override
        public boolean isModified() {
            return ModifiedValues.this.modifiedValues.containsKey(this.name);
        }

        @Override
        public Map<K, V> getModifiedValue() {
            return (Map)ModifiedValues.this.modifiedValues.get(this.name);
        }
    }

    public static interface MapProperty<K, V>
    extends Property<Map<K, V>> {
        public V getMapValue(K var1);

        public void modifyMapValue(K var1, V var2);
    }

    public static interface Property<T> {
        public T getValue();

        public T getModifiedValue();

        public boolean isModified();

        public void modifyValue(T var1);
    }
}

