/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersonalDataMeta {
    private static final Logger logger = LoggerFactory.getLogger(PersonalDataMeta.class);
    private static final String FIELD_SEMANTICS_DATASUBJECTID = "DataSubjectID";
    private static final String ENTITY_SEMANTICS_DATASUBJECT = "DataSubject";
    private static final String ENTITY_SEMANTICS_DATASUBJECTDETAILS = "DataSubjectDetails";
    private static final String ENTITY_SEMANTICS_OTHER = "Other";
    private final CdsStructuredType type;
    private final boolean hasPersonalData;
    private final boolean dataSubject;
    private final boolean dataSubjectDetails;
    private final boolean other;
    private final String dataSubjectRole;
    private Set<String> personalDataNames;
    private Set<String> sensitiveDataNames;
    private List<String> keyNames;
    private List<CdsElement> dataSubjectIds;
    private CdsElement dataSubjectAssociation;

    PersonalDataMeta(CdsStructuredType type) {
        this.type = Objects.requireNonNull(type, "type must not be null");
        boolean isDraftShadowEntity = DraftUtils.isDraftEnabled((CdsAnnotatable)type) && type.getQualifiedName().endsWith("_drafts");
        String entitySemantics = PersonalDataMeta.getEntitySemantics(this.type);
        this.hasPersonalData = entitySemantics != null && !isDraftShadowEntity;
        this.dataSubject = this.hasPersonalData && ENTITY_SEMANTICS_DATASUBJECT.equals(entitySemantics);
        this.dataSubjectDetails = this.hasPersonalData && ENTITY_SEMANTICS_DATASUBJECTDETAILS.equals(entitySemantics);
        this.other = this.hasPersonalData && ENTITY_SEMANTICS_OTHER.equals(entitySemantics);
        this.dataSubjectRole = (String)CdsAnnotations.PERSONALDATA_DATASUBJECTROLE.getOrDefault((CdsAnnotatable)type);
    }

    String getKey() {
        return this.type.getQualifiedName();
    }

    String getDataSubjectRole() {
        return this.dataSubjectRole;
    }

    boolean hasPersonalData() {
        return this.hasPersonalData;
    }

    List<CdsElement> getDataSubjectIds() {
        if (this.dataSubjectIds == null) {
            this.dataSubjectIds = Collections.unmodifiableList(this.type.elements().filter(element -> {
                String annotationValue = (String)CdsAnnotations.PERSONALDATA_FIELDSEMANTICS.getOrDefault((CdsAnnotatable)element);
                return FIELD_SEMANTICS_DATASUBJECTID.equals(annotationValue);
            }).collect(Collectors.toList()));
        }
        return this.dataSubjectIds;
    }

    List<String> getKeyNames() {
        if (this.keyNames == null) {
            this.keyNames = Collections.unmodifiableList(new ArrayList(CdsModelUtils.keyNames((CdsStructuredType)this.type)));
        }
        return this.keyNames;
    }

    Set<String> getSensitiveDataNames() {
        if (this.sensitiveDataNames == null) {
            this.sensitiveDataNames = Collections.unmodifiableSet(this.type.elements().filter(arg_0 -> ((CdsAnnotations)CdsAnnotations.PERSONALDATA_POTENTIALLYSENSITIVE).isTrue(arg_0)).map(CdsElementDefinition::getName).collect(Collectors.toSet()));
        }
        return this.sensitiveDataNames;
    }

    Set<String> getPersonalDataNames() {
        if (this.personalDataNames == null) {
            this.personalDataNames = Collections.unmodifiableSet(this.type.elements().filter(element -> CdsAnnotations.PERSONALDATA_POTENTIALLYPERSONAL.isTrue((CdsAnnotatable)element) || CdsAnnotations.PERSONALDATA_POTENTIALLYSENSITIVE.isTrue((CdsAnnotatable)element)).map(CdsElementDefinition::getName).collect(Collectors.toSet()));
        }
        return this.personalDataNames;
    }

    boolean isDataSubject() {
        return this.dataSubject;
    }

    boolean isDataSubjectDetails() {
        return this.dataSubjectDetails;
    }

    boolean isOther() {
        return this.other;
    }

    CdsElement getDataSubjectAssociation() {
        if (this.dataSubjectAssociation == null) {
            this.dataSubjectAssociation = this.getDataSubjectIds().stream().filter(element -> element.getType().isAssociation()).findFirst().orElse(null);
        }
        return this.dataSubjectAssociation;
    }

    Map<String, Object> getKeys(Map<String, Object> row) {
        HashMap<String, Object> matcher = new HashMap<String, Object>();
        this.getKeyNames().stream().filter(row::containsKey).forEach(keyField -> matcher.put((String)keyField, row.get(keyField)));
        return matcher;
    }

    public String toString() {
        return this.getKey();
    }

    private static String getEntitySemantics(CdsStructuredType entity) {
        String entitySemantics = (String)CdsAnnotations.PERSONALDATA_ENTITYSEMANTICS.getOrDefault((CdsAnnotatable)entity);
        if (entitySemantics != null) {
            switch (entitySemantics) {
                case "DataSubject": 
                case "DataSubjectDetails": 
                case "Other": {
                    return entitySemantics;
                }
            }
            logger.warn("Entity semantics '{}' not supported.", (Object)entitySemantics);
        }
        return null;
    }
}

