/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.authorization.ReferenceAssociationTraverser;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class StaticAuthorizationsDeepChecker
implements CqnVisitor {
    private final CdsModel model;
    private final CdsStructuredType current;
    private final CdsStructuredType parent;
    private final Set<String> checkedEntities;
    private final Consumer<CdsEntity> authCheck;

    public StaticAuthorizationsDeepChecker(EventContext context, CqnStatement statement, Collection<String> alreadyChecked, Consumer<CdsEntity> authCheck) {
        this(context.getModel(), null, (CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)statement, (CdsModel)context.getModel()), new HashSet<String>(alreadyChecked), authCheck);
    }

    private StaticAuthorizationsDeepChecker(CdsModel model, CdsStructuredType parent, CdsStructuredType current, Set<String> visitedEntities, Consumer<CdsEntity> authCheck) {
        this.model = Objects.requireNonNull(model);
        this.current = Objects.requireNonNull(current);
        this.parent = parent;
        this.checkedEntities = Objects.requireNonNull(visitedEntities);
        this.authCheck = Objects.requireNonNull(authCheck);
    }

    public void visit(CqnMatchPredicate match) {
        ReferenceAssociationTraverser.consume(this.current, (CqnReference)match.ref(), ReferenceAssociationTraverser.NO_COMPOSITIONS, this::checkIfAuthorized);
        match.predicate().ifPresent(p -> p.accept((CqnVisitor)this));
    }

    public void visit(CqnSelect select) {
        select.dispatch(this.newVisitor((CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)select, (CdsModel)this.model)));
    }

    public void visit(CqnStructuredTypeRef ref) {
        CdsEntity root = this.model.getEntity(ref.firstSegment());
        ReferenceAssociationTraverser.consume((CdsStructuredType)root, (CqnReference)ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::checkIfAuthorized);
    }

    public void visit(CqnElementRef ref) {
        if (ref.size() < 2 || "$user".equals(ref.firstSegment())) {
            return;
        }
        CdsStructuredType target = this.getRefRootType((CqnReference)ref);
        ReferenceAssociationTraverser.consume(target, (CqnReference)ref, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::checkIfAuthorized);
    }

    public void visit(CqnInline inline) {
        ReferenceAssociationTraverser.consume(this.current, (CqnReference)inline.ref(), ReferenceAssociationTraverser.NO_COMPOSITIONS, this::checkIfAuthorized);
        CqnVisitor visitor = this.newVisitor(CdsModelUtils.target((CdsStructuredType)this.current, (List)inline.ref().segments()));
        inline.items().forEach(i -> i.accept(visitor));
    }

    public void visit(CqnExpand expand) {
        ReferenceAssociationTraverser.consume(this.current, (CqnReference)expand.ref(), ReferenceAssociationTraverser.NO_COMPOSITIONS, this::checkIfAuthorized);
        CqnVisitor visitor = this.newVisitor(CdsModelUtils.target((CdsStructuredType)this.current, (List)expand.ref().segments()));
        expand.items().forEach(i -> i.accept(visitor));
        expand.orderBy().forEach(i -> i.accept(visitor));
    }

    public void visit(CqnExistsSubquery exists) {
        exists.subquery().accept(this.newVisitor((CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)exists.subquery(), (CdsModel)this.model)));
    }

    private void checkIfAuthorized(ResolvedSegment current) {
        if (!this.checkedEntities.contains(current.type().getQualifiedName())) {
            this.authCheck.accept(current.entity());
            this.checkedEntities.add(current.type().getQualifiedName());
        }
    }

    private CqnVisitor newVisitor(CdsStructuredType next) {
        return new StaticAuthorizationsDeepChecker(this.model, this.current, next, this.checkedEntities, this.authCheck);
    }

    private CdsStructuredType getRefRootType(CqnReference ref) {
        if ("$outer".equals(ref.firstSegment())) {
            return this.parent;
        }
        return this.current;
    }
}

