/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.cds.QueryAuthorizationCheckHelper;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class InstanceBasedAuthorizationRejectionHandler
implements EventHandler {
    private final boolean regardCustomEvents;

    public InstanceBasedAuthorizationRejectionHandler(CdsRuntime runtime) {
        CdsProperties.Security.Authorization authorization = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthorization();
        this.regardCustomEvents = authorization.getInstanceBased().getCustomEvents().isEnabled();
    }

    @Before(event={"*"})
    @HandlerOrder(value=-10700)
    private void checkAuthorization(EventContext context) {
        if (context.getUserInfo().isPrivileged()) {
            return;
        }
        if (!this.isRelevantEventForRejectionHandler(context)) {
            return;
        }
        CdsEntity targetEntity = context.getTarget();
        String eventName = context.getEvent();
        String targetEntityName = targetEntity.getQualifiedName();
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        CqnPredicate authFilter = authService.calcWhereCondition(targetEntityName, eventName);
        if (authFilter == null) {
            return;
        }
        CqnPredicate keyFilter = QueryAuthorizationCheckHelper.keyFilterFromStatement(context);
        if (keyFilter == CQL.FALSE) {
            return;
        }
        boolean hasAccess = QueryAuthorizationCheckHelper.checkAccessWithSelect(context, keyFilter, authFilter);
        if (!hasAccess) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN, new Object[]{eventName, targetEntity.getQualifiedName()});
        }
    }

    private boolean isRelevantEventForRejectionHandler(EventContext context) {
        String eventName = context.getEvent();
        if (eventName.equals("DELETE") || eventName.equals("UPDATE") || eventName.equals("draftEdit") || this.regardCustomEvents && !CdsModelUtils.isStandardCdsEvent(eventName)) {
            return context.getTarget() != null && context.get("cqn") instanceof CqnFilterableStatement;
        }
        return false;
    }
}

