/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.ValidatorErrorUtils;
import com.sap.cds.services.impl.utils.ValidatorExecutor;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class RangeAssertionHandler
implements EventHandler {
    private static final String INF = "\u221e";

    @Before
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsDataProcessor cdsDataProcessor = CdsDataProcessor.create().addValidator(RangeAssertionHandler::hasAssertRange, this.rangeValidator(context));
        ValidatorExecutor.processEntities(cdsDataProcessor, context);
    }

    private CdsDataProcessor.Validator rangeValidator(EventContext context) {
        return (path, element, value) -> {
            if (value != null) {
                List rangeValues = CdsAnnotations.ASSERT_RANGE.getListOrValue((CdsAnnotatable)element, null);
                Boundaries checks = RangeAssertionHandler.getBoundaries(context, rangeValues, element, element.getDeclaringType().getName());
                Comparable elementValue = (Comparable)value;
                if (!checks.min.test.test(elementValue) || !checks.max.test.test(elementValue)) {
                    String range = checks.min.bracket + checks.min.val.toString() + ", " + checks.max.val.toString() + checks.max.bracket;
                    ValidatorErrorUtils.handleValidationError(context, path, element, CdsErrorStatuses.VALUE_OUT_OF_RANGE, element.getName(), range);
                }
            }
        };
    }

    private static boolean hasAssertRange(Path path, CdsElement element, CdsType type) {
        List l;
        List rangeValues = CdsAnnotations.ASSERT_RANGE.getListOrValue((CdsAnnotatable)element, null);
        return rangeValues instanceof List && (l = rangeValues).size() == 2 && RangeAssertionHandler.isAllowedType(type);
    }

    private static Boundaries getBoundaries(EventContext context, List<Object> rangeValues, CdsElement element, String entityName) {
        try {
            CdsBaseType type = ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
            Check min = RangeAssertionHandler.checkMin(type, rangeValues.get(0));
            Check max = RangeAssertionHandler.checkMax(type, rangeValues.get(1));
            return new Boundaries(min, max);
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION, new Object[]{CdsAnnotations.ASSERT_RANGE.toString(), element.getName(), entityName, e});
        }
    }

    private static Check checkMin(CdsBaseType type, Object o) {
        Kind kind = RangeAssertionHandler.kind(o);
        if (kind == Kind.UNLIMITED) {
            return new Check("-\u221e", v -> true, "(");
        }
        Comparable<Object> minVal = RangeAssertionHandler.parse(type, o);
        if (kind == Kind.INCLUDING) {
            return new Check(minVal, v -> minVal.compareTo(v) <= 0, "[");
        }
        return new Check(minVal, v -> minVal.compareTo(v) < 0, "(");
    }

    private static Check checkMax(CdsBaseType type, Object o) {
        Kind kind = RangeAssertionHandler.kind(o);
        if (kind == Kind.UNLIMITED) {
            return new Check(INF, v -> true, ")");
        }
        Comparable<Object> maxVal = RangeAssertionHandler.parse(type, o);
        if (kind == Kind.INCLUDING) {
            return new Check(maxVal, v -> maxVal.compareTo(v) >= 0, "]");
        }
        return new Check(maxVal, v -> maxVal.compareTo(v) > 0, ")");
    }

    private static Kind kind(Object v) {
        Map m;
        if (v instanceof CqnLiteral) {
            return Kind.EXCLUDING;
        }
        if (v instanceof Map && "_".equals((m = (Map)v).get("="))) {
            return Kind.UNLIMITED;
        }
        return Kind.INCLUDING;
    }

    private static Comparable<Object> parse(CdsBaseType type, Object v) {
        if (v instanceof CqnLiteral) {
            CqnLiteral l = (CqnLiteral)v;
            v = l.value();
        }
        return (Comparable)CdsTypeUtils.parse((CdsBaseType)type, (String)v.toString());
    }

    private static boolean isAllowedType(CdsType elementType) {
        if (elementType instanceof CdsSimpleType) {
            CdsSimpleType st = (CdsSimpleType)elementType;
            return switch (st.getType()) {
                case CdsBaseType.INT32, CdsBaseType.INTEGER, CdsBaseType.INT64, CdsBaseType.INTEGER64, CdsBaseType.DECIMAL, CdsBaseType.DECIMAL_FLOAT, CdsBaseType.DOUBLE, CdsBaseType.DATE, CdsBaseType.TIME, CdsBaseType.DATETIME, CdsBaseType.TIMESTAMP -> true;
                default -> false;
            };
        }
        return false;
    }

    record Check(Object val, Predicate<Comparable<Object>> test, String bracket) {
    }

    record Boundaries(Check min, Check max) {
    }

    private static enum Kind {
        INCLUDING,
        EXCLUDING,
        UNLIMITED;

    }
}

