/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import java.util.HashMap;
import java.util.Map;

class DraftInactivesReader {
    private final EventContext context;

    public static DraftInactivesReader create(EventContext context) {
        return new DraftInactivesReader(context);
    }

    private DraftInactivesReader(EventContext context) {
        this.context = context;
    }

    public Result allInactives(CqnSelect select, Map<String, Object> cqnNamedValues, CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef, boolean draftAdminFromActive) {
        CqnSelect sanitized = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new InactiveSanitizer(remainingWhere, remainingRef));
        if (draftAdminFromActive) {
            return this.draftsOfAllUsers(sanitized, cqnNamedValues);
        }
        return DraftServiceImpl.downcast(this.context.getService()).readDraft(sanitized, cqnNamedValues);
    }

    public Result draftsOfAllUsers(CqnSelect select) {
        return this.draftsOfAllUsers(select, new HashMap<String, Object>(0));
    }

    public Result draftsOfAllUsers(CqnSelect select, Map<String, Object> cqnNamedValues) {
        return (Result)this.context.getCdsRuntime().requestContext().privilegedUser().modifyUser(u -> u.setName(this.context.getUserInfo().getName())).run(requestContext -> DraftServiceImpl.downcast(this.context.getService()).readDraft(select, cqnNamedValues));
    }

    private static class InactiveSanitizer
    implements Modifier {
        private final CqnPredicate remainingWhere;
        private final CqnStructuredTypeRef remainingRef;

        public InactiveSanitizer(CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef) {
            this.remainingWhere = remainingWhere;
            this.remainingRef = remainingRef;
        }

        public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
            return this.remainingRef;
        }

        public CqnPredicate where(Predicate where) {
            return this.remainingWhere;
        }
    }
}

