/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.google.common.collect.ImmutableMap;
import com.sap.cds.CdsData;
import com.sap.cds.Result;
import com.sap.cds.Struct;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.draft.DraftAdministrativeData;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftReadEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.draft.CqnAdapter;
import com.sap.cds.services.impl.draft.DraftHandlerUtils;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.impl.draft.ParentEntityLookup;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={DraftService.class})
public class InactiveHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(InactiveHandler.class);
    private final TenantAwareCache<ParentEntityLookup, CdsModel> parentEntityLookups;

    public InactiveHandler(CdsRuntime runtime) {
        this.parentEntityLookups = TenantAwareCache.create(() -> new ParentEntityLookup(RequestContext.getCurrent((CdsRuntime)runtime).getModel()), (CdsRuntime)runtime);
    }

    @Before(event={"DRAFT_NEW", "DRAFT_PATCH", "DRAFT_CANCEL"})
    @HandlerOrder(value=-10500)
    protected void checkDraft(EventContext context) {
        if (!DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DRAFT_ENABLED, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultRead(DraftReadEventContext context) {
        CqnSelect adapted = CqnAdapter.create((EventContext)context).adaptForInactiveExecution(context.getCqn());
        if (adapted == null) {
            return DraftHandlerUtils.buildNoOpResult((EventContext)context);
        }
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(adapted, context.getCqnNamedValues());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultNew(DraftNewEventContext context) {
        return DraftServiceImpl.downcast((Service)context.getService()).createDraft((CqnInsert)Insert.copy((CqnInsert)context.getCqn()), false);
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultCreate(DraftCreateEventContext context) {
        CqnInsert adapted = CqnAdapter.create((EventContext)context).adaptForInactiveExecution(context.getCqn());
        if (adapted == null) {
            return DraftHandlerUtils.buildNoOpResult((EventContext)context);
        }
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(adapted);
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultPatch(DraftPatchEventContext context) {
        CqnUpdate adapted = CqnAdapter.create((EventContext)context).adaptForInactiveExecution(context.getCqn());
        if (adapted == null) {
            return DraftHandlerUtils.buildNoOpResult((EventContext)context);
        }
        adapted = this.addSecurityConstraints(adapted, (EventContext)context);
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(adapted, context.getCqnValueSets());
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultCancel(DraftCancelEventContext context) {
        CqnDelete adapted = CqnAdapter.create((EventContext)context).adaptForInactiveExecution(context.getCqn());
        if (adapted == null) {
            return DraftHandlerUtils.buildNoOpResult((EventContext)context);
        }
        adapted = this.addSecurityConstraints(adapted, (EventContext)context);
        return CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(adapted, context.getCqnValueSets());
    }

    @After
    protected void validateDraftParent(DraftNewEventContext context) {
        if (!DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            List<ParentEntityLookup.ParentEntityLookupResult> parentLookups = ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent(context.getTarget());
            if (parentLookups == null || parentLookups.isEmpty()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_PARENT_ENTITY, new Object[]{context.getTarget().getQualifiedName()});
            }
            context.getResult().forEach(r -> {
                int numberParents = 0;
                for (ParentEntityLookup.ParentEntityLookupResult parentLookup : parentLookups) {
                    if (!DraftUtils.isDraftEnabled((CdsAnnotatable)parentLookup.getParentEntity())) continue;
                    String compositionName = parentLookup.getComposition().getName();
                    Predicate pred = CQL.get((String)"IsActiveEntity").eq((Object)false);
                    for (Map.Entry<String, Object> key : InactiveHandler.getKeys((Map<String, Object>)r, context.getTarget()).entrySet()) {
                        Predicate tmpPred = CQL.to((String)compositionName).get(key.getKey()).eq(key.getValue());
                        pred = CQL.and((CqnPredicate)pred, (CqnPredicate)tmpPred);
                    }
                    Select select = Select.from((CdsEntity)parentLookup.getParentEntity()).where((CqnPredicate)pred);
                    Result parentDrafts = DraftServiceImpl.downcast((Service)context.getService()).readDraft((CqnSelect)select, new Object[0]);
                    if (!parentDrafts.first().isPresent()) continue;
                    ++numberParents;
                }
                if (numberParents == 0) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{context.getTarget().getQualifiedName()});
                }
                if (numberParents > 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_PARENTS, new Object[]{numberParents, context.getTarget().getQualifiedName()});
                }
            });
        }
    }

    @After
    protected void updateAdminDataOnNewDraft(DraftNewEventContext context) {
        if (!DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            this.updateDraftAdministrativeDataChangeTime(context.getResult(), (EventContext)context);
        }
    }

    @Before
    @HandlerOrder(value=-10300)
    protected void updateAdminDataOnPatch(DraftPatchEventContext context) {
        List entries = context.getCqn().entries();
        Instant now = Instant.now();
        DataProcessor.create().forUpdate().action((entity, row) -> {
            if (entity.findElement("DraftAdministrativeData").isPresent()) {
                DraftAdministrativeData adminData;
                if (!entity.getQualifiedName().equals(context.getTarget().getQualifiedName())) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DRAFT_DEEP_UPDATE, new Object[0]);
                }
                if (row.containsKey("DraftAdministrativeData")) {
                    adminData = (DraftAdministrativeData)Struct.access((Map)((Map)row.get("DraftAdministrativeData"))).as(DraftAdministrativeData.class);
                } else {
                    adminData = (DraftAdministrativeData)Struct.create(DraftAdministrativeData.class);
                    row.put("DraftAdministrativeData", adminData);
                }
                adminData.setLastChangeDateTime(now);
            }
        }).process((Iterable)entries, (CdsStructuredType)context.getTarget());
    }

    @Before
    @HandlerOrder(value=11000)
    protected void updateAdminDataOnDeletion(DraftCancelEventContext context) {
        if (!DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            Select select = CqnUtils.toSelect((CqnDelete)context.getCqn()).columns(new String[]{"DraftAdministrativeData"});
            this.updateDraftAdministrativeDataChangeTime(DraftServiceImpl.downcast((Service)context.getService()).readDraft((CqnSelect)select, new Object[0]), (EventContext)context);
        }
    }

    @Before
    @HandlerOrder(value=-10300)
    protected void addDraftFields(DraftCreateEventContext context, List<CdsData> entries) {
        Instant now = Instant.now();
        for (CdsData m : entries) {
            String draftUUID = this.determineDraftUuid((Map<String, Object>)m, context);
            DataProcessor.create().forInsert().action((entity, data) -> {
                if (DraftUtils.isDraftEnabled((CdsAnnotatable)entity)) {
                    Drafts draft = (Drafts)Struct.access((Map)data).as(Drafts.class);
                    draft.setHasActiveEntity(context.getHasActiveEntity());
                    draft.setHasDraftEntity(Boolean.valueOf(false));
                    draft.setIsActiveEntity(Boolean.valueOf(false));
                    draft.setDraftAdministrativeDataDraftUuid(draftUUID);
                    DraftAdministrativeData dad = draft.getDraftAdministrativeData();
                    if (dad == null) {
                        dad = (DraftAdministrativeData)Struct.create(DraftAdministrativeData.class);
                    }
                    dad.setDraftUUID(draftUUID);
                    if (DraftUtils.isDraftRoot((CdsAnnotatable)entity)) {
                        String userName = context.getUserInfo().getName();
                        dad.setCreatedByUser(userName);
                        dad.setCreationDateTime(now);
                        dad.setLastChangeDateTime(now);
                        dad.setInProcessByUser(userName);
                        dad.setLastChangedByUser(userName);
                    }
                    draft.setDraftAdministrativeData((Map)dad);
                }
            }).process((Map)m, (CdsStructuredType)context.getTarget());
        }
    }

    private <S extends CqnStatement> S addSecurityConstraints(S stmt, EventContext context) {
        return (S)CqnUtils.addWhere(stmt, (CqnPredicate)DraftModifier.getSecurityConstraints(context));
    }

    private String determineDraftUuid(Map<String, Object> m, DraftCreateEventContext context) {
        CdsEntity potentialParent;
        Drafts draftData = (Drafts)Struct.access(m).as(Drafts.class);
        if (draftData.getDraftAdministrativeDataDraftUuid() != null) {
            return draftData.getDraftAdministrativeDataDraftUuid();
        }
        if (draftData.getDraftAdministrativeData() != null && draftData.getDraftAdministrativeData().getDraftUUID() != null) {
            return draftData.getDraftAdministrativeData().getDraftUUID();
        }
        if (DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            return UUID.randomUUID().toString();
        }
        Result result = null;
        long numParents = 0L;
        HashSet<String> uniqueParents = new HashSet<String>();
        CqnStructuredTypeRef ref = context.getCqn().ref();
        List<ParentEntityLookup.ParentEntityLookupResult> lookupResultList = ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent(context.getTarget());
        AnalysisResult analysisResult = CdsModelUtils.getEntityPath(ref, context.getModel());
        Iterator iter = analysisResult.reverse();
        iter.next();
        CdsEntity cdsEntity = potentialParent = iter.hasNext() ? ((ResolvedSegment)iter.next()).entity() : null;
        if (potentialParent != null && lookupResultList.stream().anyMatch(lr -> lr.getParentEntity().equals(potentialParent))) {
            Select select = Select.from((StructuredType)CQL.to(ref.segments().subList(0, ref.size() - 1))).columns(new String[]{"DraftAdministrativeData"});
            result = DraftServiceImpl.downcast((Service)context.getService()).readDraft((CqnSelect)select, new Object[0]);
            numParents = result.rowCount();
        } else {
            for (ParentEntityLookup.ParentEntityLookupResult lookupResult : lookupResultList) {
                CdsEntity parentEntity = lookupResult.getParentEntity();
                if (uniqueParents.contains(parentEntity.getQualifiedName()) || !DraftUtils.isDraftEnabled((CdsAnnotatable)parentEntity)) continue;
                uniqueParents.add(parentEntity.getQualifiedName());
                OnConditionAnalyzer analyzer = new OnConditionAnalyzer(lookupResult.getComposition(), false);
                Map foreignKeysParent = analyzer.getFkValues(m);
                foreignKeysParent.put("IsActiveEntity", false);
                Select select = Select.from((CdsEntity)parentEntity).matching(foreignKeysParent).columns(new String[]{"DraftAdministrativeData"});
                Result tmpResult = DraftServiceImpl.downcast((Service)context.getService()).readDraft((CqnSelect)select, new Object[0]);
                numParents += tmpResult.rowCount();
                if (tmpResult.first().isPresent()) {
                    result = tmpResult;
                }
                if (numParents <= 1L) continue;
                break;
            }
        }
        if (numParents > 1L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_PARENTS, new Object[]{numParents, context.getTarget().getQualifiedName()});
        }
        if (numParents == 0L || result == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PARENT_NOT_EXISTING, new Object[]{context.getTarget().getQualifiedName()});
        }
        DraftAdministrativeData data = ((Drafts)result.single().as(Drafts.class)).getDraftAdministrativeData();
        return data != null ? data.getDraftUUID() : null;
    }

    private static Map<String, Object> getKeys(Map<String, Object> m, CdsEntity entity) {
        HashMap<String, Object> result = new HashMap<String, Object>(m);
        result.entrySet().removeIf(entry -> entity.findElement((String)entry.getKey()).map(e -> e.isKey()).orElse(false) == false && !"IsActiveEntity".equals(entry.getKey()));
        if ((long)result.size() != entity.keyElements().filter(element -> !element.getType().isAssociation()).count()) {
            logger.error("Failed to find keys of {} in result {}", (Object)entity, m);
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_KEYS_IN_RESULT, new Object[]{entity});
        }
        return result;
    }

    private void updateDraftAdministrativeDataChangeTime(Result result, EventContext context) {
        Instant now = Instant.now();
        List updates = result.streamOf(Drafts.class).map(row -> row.getDraftAdministrativeData()).filter(Objects::nonNull).map(row -> row.getDraftUUID()).filter(Objects::nonNull).distinct().map(uuid -> ImmutableMap.of((Object)"DraftUUID", (Object)uuid, (Object)"LastChangeDateTime", (Object)now)).collect(Collectors.toList());
        if (!updates.isEmpty()) {
            PersistenceService persistenceService = (PersistenceService)context.getCdsRuntime().getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
            persistenceService.run((CqnUpdate)Update.entity((String)"DRAFT.DraftAdministrativeData").entries(updates), new Object[0]);
        }
    }
}

