/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry;

import com.sap.cds.services.impl.EventPredicate;
import com.sap.cds.services.utils.StringUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class EventPredicateTools {
    private EventPredicateTools() {
    }

    public static EventPredicate create(String[] eventNames, String[] entityNames) {
        Collection<String> evCol = EventPredicateTools.toMatchCollection(eventNames);
        Collection<String> etCol = EventPredicateTools.toMatchCollection(entityNames);
        if (evCol.size() > 1 || etCol.size() > 1) {
            return new EventPredicateCollection(evCol, etCol);
        }
        return EventPredicateTools.create(EventPredicateTools.firstOf(evCol), EventPredicateTools.firstOf(etCol));
    }

    public static EventPredicate create(String event, String entity) {
        event = EventPredicateTools.toMatchString(event);
        entity = EventPredicateTools.toMatchString(entity);
        return event == null && entity == null ? EventPredicate.ALL : new EventPredicateString(event, entity);
    }

    static Collection<String> toMatchCollection(String[] data) {
        if (data == null || data.length == 0) {
            return Collections.emptySet();
        }
        if (data.length == 1) {
            String str = EventPredicateTools.toMatchString(data[0]);
            return str == null ? Collections.emptySet() : Collections.singleton(str);
        }
        HashSet<String> res = new HashSet<String>();
        Collections.addAll(res, data);
        if (res.contains("*") || res.contains("")) {
            return Collections.emptySet();
        }
        res.remove(null);
        switch (res.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((String)res.iterator().next());
            }
        }
        return res;
    }

    private static <T> T firstOf(Collection<T> coll) {
        return coll.isEmpty() ? null : (T)coll.iterator().next();
    }

    private static String toMatchString(String data) {
        if (data == null || data.isEmpty() || "*".equals(data)) {
            return null;
        }
        return data;
    }

    private static final class EventPredicateCollection
    implements EventPredicate {
        private final Collection<String> events;
        private final Collection<String> entities;

        public EventPredicateCollection(Collection<String> events, Collection<String> entities) {
            this.events = events.isEmpty() ? null : events;
            this.entities = entities.isEmpty() ? null : entities;
        }

        @Override
        public boolean test(String event, String entity) {
            return !(this.events != null && !this.events.contains(event) || this.entities != null && !this.entities.contains(entity));
        }

        public String toString() {
            return MessageFormat.format("events ''{0}'' on entities ''{1}''", this.events != null && !this.events.isEmpty() ? this.events : "*", this.entities != null && !this.entities.isEmpty() ? this.entities : "*");
        }
    }

    private static final class EventPredicateString
    implements EventPredicate {
        private final String event;
        private final String entity;

        public EventPredicateString(String event, String entity) {
            this.event = event;
            this.entity = entity;
        }

        @Override
        public boolean test(String event, String entity) {
            return !(this.event != null && !this.event.equals(event) || this.entity != null && !this.entity.equals(entity));
        }

        public String toString() {
            return MessageFormat.format("event ''{0}'' on entity ''{1}''", StringUtils.notEmpty((String[])new String[]{this.event, "*"}), StringUtils.notEmpty((String[])new String[]{this.entity, "*"}));
        }
    }
}

