/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.google.common.collect.Sets;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.draft.ActiveReadEventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftReadEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.impl.handlerregistry.AnnotationDescriptor;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ReturnResolver;
import com.sap.cds.services.impl.utils.ReflectionUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ListUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultReturnResolver
implements ReturnResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResultReturnResolver.class);
    private static final Set<String> allowedEvents = Sets.newHashSet((Object[])new String[]{"READ", "CREATE", "UPDATE", "DELETE", "UPSERT", "draftEdit", "draftPrepare", "draftActivate", "DRAFT_NEW", "DRAFT_PATCH", "DRAFT_CANCEL", "DRAFT_CREATE", "DRAFT_READ", "ACTIVE_READ"});
    private static final HashMap<Type, ResultReturnResolver> cache = new HashMap();
    private final boolean isIterable;
    private final Type genericType;

    public static ResultReturnResolver createIfApplicable(Type type) {
        ResultReturnResolver cached = cache.get(type);
        if (cached != null) {
            return cached;
        }
        try {
            if (ResultReturnResolver.isApplicableIterableType(type)) {
                return new ResultReturnResolver(true, type);
            }
            if (ResultReturnResolver.isApplicableMapType(type)) {
                return new ResultReturnResolver(false, type);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            logger.debug("Could not resolve generic type '{}'", (Object)type.getTypeName(), (Object)e);
        }
        return null;
    }

    private static boolean isApplicableIterableType(Type iterableType) throws ClassNotFoundException {
        if (iterableType == null) {
            return false;
        }
        if (ReflectionUtils.isParameterizedType(iterableType)) {
            ParameterizedType paramIterableType = ReflectionUtils.getParameterizedType(iterableType);
            if (Iterable.class.isAssignableFrom(ReflectionUtils.getClassForType(paramIterableType.getRawType())) && paramIterableType.getActualTypeArguments().length == 1 && ResultReturnResolver.isApplicableMapType(paramIterableType.getActualTypeArguments()[0])) {
                return true;
            }
        } else {
            Class<?> iterableExtender = ReflectionUtils.getClassForType(iterableType);
            if (Iterable.class.isAssignableFrom(iterableExtender)) {
                boolean applicableIterable = false;
                if (iterableExtender.getSuperclass() != Object.class) {
                    applicableIterable = ResultReturnResolver.isApplicableIterableType(iterableExtender.getGenericSuperclass());
                }
                if (!applicableIterable) {
                    Type genericInterface;
                    Type[] typeArray = iterableExtender.getGenericInterfaces();
                    int n = typeArray.length;
                    for (int i = 0; i < n && !(applicableIterable = ResultReturnResolver.isApplicableIterableType(genericInterface = typeArray[i])); ++i) {
                    }
                }
                return applicableIterable;
            }
        }
        return false;
    }

    private static boolean isApplicableMapType(Type mapType) throws ClassNotFoundException {
        if (mapType == null) {
            return false;
        }
        if (ReflectionUtils.isParameterizedType(mapType)) {
            ParameterizedType paramMapType = ReflectionUtils.getParameterizedType(mapType);
            if (Map.class.isAssignableFrom(ReflectionUtils.getClassForType(paramMapType.getRawType())) && paramMapType.getActualTypeArguments().length == 2) {
                Type stringClazzType = paramMapType.getActualTypeArguments()[0];
                return String.class.isAssignableFrom(ReflectionUtils.getClassForType(stringClazzType));
            }
        } else {
            Class<?> mapExtender = ReflectionUtils.getClassForType(mapType);
            if (Map.class.isAssignableFrom(mapExtender)) {
                boolean applicableMap = false;
                if (mapExtender.getSuperclass() != Object.class) {
                    applicableMap = ResultReturnResolver.isApplicableMapType(mapExtender.getGenericSuperclass());
                }
                if (!applicableMap) {
                    Type genericInterface;
                    Type[] typeArray = mapExtender.getGenericInterfaces();
                    int n = typeArray.length;
                    for (int i = 0; i < n && !(applicableMap = ResultReturnResolver.isApplicableMapType(genericInterface = typeArray[i])); ++i) {
                    }
                }
                return applicableMap;
            }
        }
        return false;
    }

    private ResultReturnResolver(boolean isIterable, Type genericType) {
        this.isIterable = isIterable;
        this.genericType = genericType;
        cache.put(genericType, this);
    }

    @Override
    public void resolve(Object returnValue, EventContext context) {
        Iterable iterable = !this.isIterable ? ListUtils.getList((Object[])new Map[]{(Map)returnValue}) : (Iterable)returnValue;
        switch (context.getEvent()) {
            case "READ": {
                ((CdsReadEventContext)context.as(CdsReadEventContext.class)).setResult(iterable);
                break;
            }
            case "CREATE": {
                ((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).setResult(iterable);
                break;
            }
            case "UPDATE": {
                ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).setResult(iterable);
                break;
            }
            case "DELETE": {
                ((CdsDeleteEventContext)context.as(CdsDeleteEventContext.class)).setResult(iterable);
                break;
            }
            case "UPSERT": {
                ((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).setResult(iterable);
                break;
            }
            case "draftEdit": {
                ((DraftEditEventContext)context.as(DraftEditEventContext.class)).setResult(iterable);
                break;
            }
            case "draftPrepare": {
                ((DraftPrepareEventContext)context.as(DraftPrepareEventContext.class)).setResult(iterable);
                break;
            }
            case "draftActivate": {
                ((DraftSaveEventContext)context.as(DraftSaveEventContext.class)).setResult(iterable);
                break;
            }
            case "DRAFT_NEW": {
                ((DraftNewEventContext)context.as(DraftNewEventContext.class)).setResult(iterable);
                break;
            }
            case "DRAFT_PATCH": {
                ((DraftPatchEventContext)context.as(DraftPatchEventContext.class)).setResult(iterable);
                break;
            }
            case "DRAFT_CANCEL": {
                ((DraftCancelEventContext)context.as(DraftCancelEventContext.class)).setResult(iterable);
                break;
            }
            case "DRAFT_CREATE": {
                ((DraftCreateEventContext)context.as(DraftCreateEventContext.class)).setResult(iterable);
                break;
            }
            case "DRAFT_READ": {
                ((DraftReadEventContext)context.as(DraftReadEventContext.class)).setResult(iterable);
                break;
            }
            case "ACTIVE_READ": {
                ((ActiveReadEventContext)context.as(ActiveReadEventContext.class)).setResult(iterable);
                break;
            }
        }
    }

    @Override
    public void verifyOrThrow(HandlerDescriptor descriptor) {
        HashSet<String> events = new HashSet<String>();
        for (AnnotationDescriptor ad : descriptor.getAnnotations()) {
            events.addAll(Arrays.asList(ad.getEvents()));
        }
        for (String event : events) {
            this.verifyEventOrThrow(event, descriptor);
        }
    }

    private void verifyEventOrThrow(String event, HandlerDescriptor descriptor) {
        if (!allowedEvents.contains(event)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RETURN_TYPE_MISMATCH, new Object[]{event, this.genericType.getTypeName(), descriptor.getMethodName()});
        }
    }
}

