/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.impl.parser.PathParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.messages.MessageTarget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;

public class MessageTargetImpl
implements MessageTarget {
    private final String parameter;
    private final CqnReference reference;

    private MessageTargetImpl(String parameter, CqnReference reference) {
        this.parameter = parameter;
        this.reference = reference;
    }

    public static MessageTarget create(Path path, CdsElement element) {
        ArrayList segments = new ArrayList();
        Iterator iterator = path.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        iterator.forEachRemaining(resolvedSegment -> segments.add(resolvedSegment.segment()));
        segments.addAll(PathParser.segments((String)element.getName()));
        Object ref = element.getType().isAssociation() ? CQL.to(segments).asRef() : CQL.get(segments);
        return new MessageTargetImpl("cqn", (CqnReference)ref);
    }

    public static MessageTarget create(String target) {
        return new MessageTargetImpl(target, null);
    }

    public static MessageTarget create(String parameter, CqnReference reference) {
        return new MessageTargetImpl(parameter, reference);
    }

    public static MessageTarget create(String parameter, Function<StructuredType<?>, Object> path) {
        return MessageTargetImpl.create(parameter, CQL.entity((String)"SKIP"), path);
    }

    public static <E extends StructuredType<E>> MessageTarget create(String parameter, Class<E> type, Function<E, Object> path) {
        return MessageTargetImpl.create(parameter, CQL.entity(type), path);
    }

    private static MessageTarget create(String parameter, StructuredType<?> rootElement, Function<StructuredType<?>, Object> path) {
        boolean structured = false;
        ArrayList segments = new ArrayList();
        Object p = path.apply(rootElement);
        if (p instanceof StructuredType) {
            StructuredType type = (StructuredType)p;
            structured = true;
            segments.addAll(type.asRef().segments());
        } else if (p instanceof ElementRef) {
            ElementRef ref = (ElementRef)p;
            segments.addAll(ref.segments());
        } else {
            return null;
        }
        String entityName = rootElement.asRef().firstSegment();
        if (entityName.equals(((CqnReference.Segment)segments.get(0)).id())) {
            segments.remove(0);
        }
        if (structured) {
            return new MessageTargetImpl(parameter, (CqnReference)CQL.to(segments).asRef());
        }
        return new MessageTargetImpl(parameter, (CqnReference)CQL.get(segments));
    }

    public CqnReference getRef() {
        return this.reference;
    }

    public String getParameter() {
        return this.parameter;
    }
}

