/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.outbox.OutboxedAsyncServiceInvocationHandler;
import com.sap.cds.services.impl.outbox.OutboxedServiceInvocationHandler;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class OutboxedServiceProxyUtils {
    private OutboxedServiceProxyUtils() {
    }

    public static <S extends Service> S unboxed(S service) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler serviceInvocationHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            return (S)serviceInvocationHandler.getDelegatedService();
        }
        return service;
    }

    public static <S extends Service> S outboxed(OutboxService outboxService, S service, CdsRuntime runtime) {
        InvocationHandler invocationHandler;
        OutboxedServiceProxyUtils.ensureNotOutboxService(service);
        Object serviceForOutboxing = service;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler serviceInvocationHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            if (serviceInvocationHandler.getOutboxService() == outboxService) {
                return service;
            }
            serviceForOutboxing = serviceInvocationHandler.getDelegatedService();
        }
        invocationHandler = new OutboxedServiceInvocationHandler(outboxService, (Service)serviceForOutboxing, runtime);
        return (S)((Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), OutboxedServiceProxyUtils.getInterfaces(service), invocationHandler));
    }

    public static <A extends Service> A outboxed(OutboxService outboxService, Service service, Class<A> asyncInterface, CdsRuntime runtime) {
        OutboxedServiceProxyUtils.ensureNotOutboxService(service);
        if (asyncInterface.isAssignableFrom(service.getClass())) {
            return (A)OutboxedServiceProxyUtils.outboxed(outboxService, service, runtime);
        }
        Service serviceForOutboxing = OutboxedServiceProxyUtils.unboxed(service);
        Map<Method, Method> methodMapping = OutboxedServiceProxyUtils.getAsyncInterfaceMethodMapping(service, asyncInterface);
        OutboxedAsyncServiceInvocationHandler invocationHandler = new OutboxedAsyncServiceInvocationHandler(outboxService, serviceForOutboxing, methodMapping, runtime);
        return (A)((Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{asyncInterface}, (InvocationHandler)invocationHandler));
    }

    private static <S extends Service> void ensureNotOutboxService(S service) {
        if (service instanceof OutboxService) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.OUTBOX_SERVICE_NOT_OUTBOXABLE, new Object[]{service.getName()});
        }
    }

    private static Map<Method, Method> getAsyncInterfaceMethodMapping(Service service, Class<? extends Service> asyncInterface) {
        if (!asyncInterface.isInterface()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ASYNC_INTERFACE_NO_INTERFACE, new Object[]{asyncInterface.getName()});
        }
        HashMap<Method, Method> methodMapping = new HashMap<Method, Method>();
        ArrayList<String> missingMethodReferences = new ArrayList<String>();
        Class<?> serviceClass = service.getClass();
        for (Method asyncMethod : asyncInterface.getMethods()) {
            try {
                if (Modifier.isStatic(asyncMethod.getModifiers())) continue;
                Method serviceMethod = serviceClass.getMethod(asyncMethod.getName(), asyncMethod.getParameterTypes());
                methodMapping.put(asyncMethod, serviceMethod);
            }
            catch (NoSuchMethodException e) {
                missingMethodReferences.add(asyncMethod.getName());
            }
        }
        if (!missingMethodReferences.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ASYNC_SERVICE_INTERFACE_DECLARES_UNKNOWN_METHOD, new Object[]{asyncInterface.getName(), String.join((CharSequence)", ", missingMethodReferences), service.getName()});
        }
        return methodMapping;
    }

    private static Class<?>[] getInterfaces(Service service) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> clazz = service.getClass();
        do {
            LinkedHashSet nextInterfaces = new LinkedHashSet(Arrays.asList(clazz.getInterfaces()));
            if (interfaces.size() == 1) {
                boolean allAssignable = true;
                Class current = (Class)interfaces.iterator().next();
                for (Class clazz2 : nextInterfaces) {
                    if (clazz2.isAssignableFrom(current)) continue;
                    allAssignable = false;
                    break;
                }
                if (allAssignable) continue;
                interfaces.addAll(nextInterfaces);
                continue;
            }
            interfaces.addAll(nextInterfaces);
        } while ((clazz = clazz.getSuperclass()) != null);
        return interfaces.toArray(new Class[0]);
    }
}

