/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.Result;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.impl.EventContextSPI;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.cds.TypedCqnServiceInvocationHandler;
import com.sap.cds.services.impl.outbox.OutboxedServiceInvocationHandler;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.util.PathExpressionResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class CdsServiceUtils {
    public static PersistenceService getDefaultPersistenceService(EventContext context) {
        return (PersistenceService)context.getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
    }

    public static ServiceSPI getServiceSPI(Service service) {
        InvocationHandler invocationHandler;
        if (service instanceof ServiceSPI) {
            ServiceSPI pI = (ServiceSPI)service;
            return pI;
        }
        if (service instanceof ServiceDelegator) {
            ServiceDelegator delegator = (ServiceDelegator)service;
            return CdsServiceUtils.getServiceSPI(delegator.getDelegatedService());
        }
        if (service != null && Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof TypedCqnServiceInvocationHandler) {
            TypedCqnServiceInvocationHandler proxyHandler = (TypedCqnServiceInvocationHandler)invocationHandler;
            return CdsServiceUtils.getServiceSPI(proxyHandler.getDelegatedService());
        }
        if (service != null && Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler proxyHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            return CdsServiceUtils.getServiceSPI(proxyHandler.getDelegatedService());
        }
        return null;
    }

    public static Class<?> getServiceType(Service service) {
        Class<?>[] interfaces;
        Class<?> clazz = service.getClass();
        if (Proxy.isProxyClass(clazz) && (interfaces = clazz.getInterfaces()).length == 1) {
            return interfaces[0];
        }
        return clazz;
    }

    public static List<Map<String, Object>> getEntities(EventContext context) {
        Object cqn = context.get("cqn");
        if (cqn instanceof CqnXsert) {
            CqnXsert x = (CqnXsert)cqn;
            return x.entries();
        }
        if (cqn instanceof CqnUpdate) {
            CqnUpdate u = (CqnUpdate)cqn;
            return u.entries();
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static List<Map<String, Object>> getEntitiesResolved(EventContext context) {
        Object cqn = context.get("cqn");
        if (cqn instanceof CqnXsert) {
            CqnXsert x = (CqnXsert)cqn;
            return PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (CqnXsert)x, (SessionContext)SessionContextUtils.toSessionContext((EventContext)context)).entries();
        }
        if (cqn instanceof CqnUpdate) {
            CqnUpdate u = (CqnUpdate)cqn;
            return PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (CqnUpdate)u).entries();
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static Result getResult(EventContext context) {
        Object object = context.get("result");
        if (object instanceof Result) {
            Result r = (Result)object;
            return r;
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static EventContextSPI getEventContextSPI(EventContext eventContext) {
        if (eventContext instanceof EventContextSPI) {
            EventContextSPI pI = (EventContextSPI)eventContext;
            return pI;
        }
        if (eventContext instanceof EventContextDelegator) {
            EventContextDelegator delegator = (EventContextDelegator)eventContext;
            return CdsServiceUtils.getEventContextSPI(delegator.getDelegatedEventContext());
        }
        return null;
    }
}

