context com.sap.cds.services.auditlog {

    /**
     * Data access interface for logging successful and
     * unsuccessful access to any sensitive personal data.
     */
    event dataAccessLog {
        /**
         * All data accesses to log.
         */
        accesses      : array of Access;
//        accessFilters : array of KeyValuePair;
    };

    /**
     * Data modification interface for logging successful and
     * unsuccessful modification to any sensitive personal data.
     */
    event dataModificationLog : {
        /**
         * All modifications to log.
         */
        modifications : array of DataModification;
    };

    /*
        // * additional events per specific action
        event dataInsertLog : {
            inserts : array of DataInsert;
        };

        event dataUpdateLog : {
            updates : array of DataUpdate;
        };

        event dataDeleteLog : {
            deletes : array of DataDelete;
        };
    */

    // config change
    event configChangeLog : {
        action         : String @assert.range enum {
            Create;
            Update;
            Delete
        };
//        success        : Boolean;
        configurations : array of ConfigChange;
    };

    // security message
    // * one event for all actions
    event securityLog : {
        action : String;
        data   : String;
    };

    /*
        // * additional events per specific actions
        event loginSuccessLog : {
            data : String;
        };

        event loginNoSuccessLog : {
            data : String;
        };
    */

    // types
    define type Access {
        /**
         * The object where the accessed personal data that is being
         * audit logged is contained.
         */
        dataObject  : DataObject;
        /**
         * The data subject whom the accessed personal data that is
         * being audit logged belongs to.
         */
        dataSubject : DataSubject;
        /**
         * The attributes that have been read
         */
        attributes  : array of Attribute;
        /**
         * Attachments in case the event is triggered by the download
         * or display of some attachments or files.
         */
        attachments : array of Attachment;
    };

    /**
     * The data subject whom the accessed personal data that is
     * being audit logged belongs to.
     */
    define type DataSubject {
        /**
         * Type to the data subject
         */
        type : String;
        id   : array of KeyValuePair;
        /**
         * Role to the data subject.
         */
        role : String;
    };

    /**
     * An attribute that was read or modified.
     */
    define type Attribute {
        /**
         * The attribute name.
         */
        name : String;
    };

    /**
     * Attachment name and identifier in case the audit log event
     * is triggered by the download or display of some attachments
     * or files
     */
    define type Attachment {
        /**
         * The attachment identifier.
         */
        id   : String;
        /**
         * The attachment name.
         */
        name : String;
    };

    define type DataModification {
        /**
         * The object where the modified personal data that is being
         * audit logged is contained.
         */
        dataObject  : DataObject;
        /**
         * The data subject whom the modified personal data that is
         * being audit logged belongs to.
         */
        dataSubject : DataSubject;
        /**
         * The action that was performed: Create, Update, Delete.
         */
        action      : String @assert.range enum {
            Create;
            Update;
            Delete
        };
        /**
         * A list with changed attributes.
         */
        attributes  : array of ChangedAttribute;
    }

    /*
        define type DataInsert {
            object      : Object;
            dataSubject : DataSubject;
            attributes  : array of InsertedAttribute;
        }

        define type DataUpdate {
            object      : Object;
            dataSubject : DataSubject;
            attributes  : array of ChangedAttribute;
        }

        define type DataDelete {
            object      : Object;
            dataSubject : DataSubject;
            attributes  : array of DeletedAttribute;
        }
    */

    define type ConfigChange {
        dataObject : DataObject;
        attributes : array of ChangedAttribute;
    };

    /**
     * The object where the accessed or modified personal data that
     * is being audit logged is contained.
     */
    define type DataObject {
        /**
         * The object type.
         */
        type : String;
        /**
         * The unique object identifier.
         */
        id   : array of KeyValuePair;
    };

    /**
     * An attribute that has been modified
     */
    define type ChangedAttribute {
        /**
         * The attribute name.
         */
        name     : String;
        /**
         * The old value.
         */
        oldValue : String;
        /**
         * The new value.
         */
        newValue : String;
    };

    /*
        define type InsertedAttribute {
            name     : String;
            newValue : String;
        };

        define type DeletedAttribute {
            name     : String;
            oldValue : String;
        };
    */

    /**
     * A generic key-value pair.
     */
    define type KeyValuePair {
        /**
         * The key name.
         */
        keyName : String;
        /**
         * The corresponding value.
         */
        value   : String;
    };
}
