/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.application;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.docs.config.DocumentedProperty;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.application.CdsPropertiesLogger;
import com.sap.cds.services.impl.application.CdsPropertyLoggingContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationLifecycleService.class})
public class ApplicationLifecycleLogCdsPropertiesHandler
implements EventHandler {
    private final CdsPropertiesLogger cdsPropertiesLogger;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLifecycleLogCdsPropertiesHandler.class);

    public ApplicationLifecycleLogCdsPropertiesHandler() {
        this(new CdsPropertiesLogger());
    }

    @VisibleForTesting
    ApplicationLifecycleLogCdsPropertiesHandler(CdsPropertiesLogger logger) {
        this.cdsPropertiesLogger = logger;
    }

    @On
    public void logCdsProperties(ApplicationPreparedEventContext context) {
        if (!this.cdsPropertiesLogger.isLoggingEnabled()) {
            return;
        }
        CdsProperties cdsProperties = context.getCdsRuntime().getEnvironment().getCdsProperties();
        this.logNonDefaults(cdsProperties);
    }

    private void logNonDefaults(CdsProperties actualValue) {
        CdsProperties defaultValue = new CdsProperties();
        List<CdsPropertyLoggingContext> propertiesWithNonDefaultValues = this.identifyNonDefaultProperties(defaultValue, actualValue, "cds", false, true, false);
        this.cdsPropertiesLogger.log(propertiesWithNonDefaultValues);
    }

    private List<CdsPropertyLoggingContext> identifyNonDefaultProperties(Object defaultValue, Object actualValue, String parentPath, boolean isAncestorDeprecated, boolean isAncestorDocumented, boolean isAncestorSensitiveData) {
        ArrayList<CdsPropertyLoggingContext> propertiesWithNonDefaultValues = new ArrayList<CdsPropertyLoggingContext>();
        if (this.needsUnwrapping(defaultValue, actualValue)) {
            propertiesWithNonDefaultValues.addAll(this.unwrapProperties(defaultValue, actualValue, parentPath, isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
        } else if (!Objects.equals(defaultValue, actualValue)) {
            propertiesWithNonDefaultValues.add(new CdsPropertyLoggingContext(defaultValue, actualValue, parentPath, isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
        }
        return propertiesWithNonDefaultValues;
    }

    private List<CdsPropertyLoggingContext> unwrapProperties(Object defaultValue, Object actualValue, String parentPath, boolean isAncestorDeprecated, boolean isAncestorDocumented, boolean isAncestorSensitiveData) {
        ArrayList<CdsPropertyLoggingContext> propertiesWithNonDefaultValues = new ArrayList<CdsPropertyLoggingContext>();
        if (defaultValue instanceof List || actualValue instanceof List) {
            List l;
            List l2;
            List actualList = actualValue instanceof List ? (l2 = (List)actualValue) : Collections.emptyList();
            List defaultList = defaultValue instanceof List ? (l = (List)defaultValue) : Collections.emptyList();
            for (int i = 0; i < Math.max(actualList.size(), defaultList.size()); ++i) {
                Object defaultValue2;
                Object actualValue1;
                if (i < actualList.size() && (actualValue1 = actualList.get(i)) != null && !defaultList.contains(actualValue1)) {
                    propertiesWithNonDefaultValues.addAll(this.identifyNonDefaultProperties(null, actualValue1, parentPath + "[" + i + "]", isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
                }
                if (i >= defaultList.size() || (defaultValue2 = defaultList.get(i)) == null || actualList.contains(defaultValue2)) continue;
                propertiesWithNonDefaultValues.addAll(this.identifyNonDefaultProperties(defaultValue2, null, parentPath + "[" + i + "]", isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
            }
        } else if (defaultValue instanceof Map || actualValue instanceof Map) {
            Map m;
            Map m2;
            Map actualMap = actualValue instanceof Map ? (m2 = (Map)actualValue) : Collections.emptyMap();
            Map defaultMap = defaultValue instanceof Map ? (m = (Map)defaultValue) : Collections.emptyMap();
            HashSet unionKeySet = new HashSet(defaultMap.keySet());
            unionKeySet.addAll(actualMap.keySet());
            for (Object key : unionKeySet) {
                Object defaultValue1 = defaultMap.get(key);
                Object actualValue1 = actualMap.get(key);
                propertiesWithNonDefaultValues.addAll(this.identifyNonDefaultProperties(defaultValue1, actualValue1, parentPath + "." + key, isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
            }
        } else if (defaultValue != null && this.isCdsPropertyClass(defaultValue) || actualValue != null && this.isCdsPropertyClass(actualValue)) {
            propertiesWithNonDefaultValues.addAll(this.unwrapCdsPropertyClass(defaultValue, actualValue, parentPath, isAncestorDeprecated, isAncestorDocumented, isAncestorSensitiveData));
        }
        return propertiesWithNonDefaultValues;
    }

    private List<CdsPropertyLoggingContext> unwrapCdsPropertyClass(Object defaultValue, Object actualValue, String parentPath, boolean isAncestorDeprecated, boolean isAncestorDocumented, boolean isAncestorSensitiveData) {
        ArrayList<CdsPropertyLoggingContext> propertiesWithNonDefaultValues = new ArrayList<CdsPropertyLoggingContext>();
        if (defaultValue == null && actualValue == null) {
            return propertiesWithNonDefaultValues;
        }
        Object nonNullCdsProperties = ObjectUtils.firstNonNull((Object[])new Object[]{defaultValue, actualValue});
        Class<?> cdsPropertiesClass = nonNullCdsProperties.getClass();
        try {
            defaultValue = defaultValue != null ? defaultValue : cdsPropertiesClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Could not instantiate class '{}': {}", (Object)cdsPropertiesClass.getName(), (Object)e.getMessage());
            return propertiesWithNonDefaultValues;
        }
        for (Field field : cdsPropertiesClass.getDeclaredFields()) {
            Optional<Method> getter = this.findGetter(field, cdsPropertiesClass);
            Object defaultFieldValue = this.getValue(defaultValue, field, getter, parentPath);
            Object actualFieldValue = this.getValue(actualValue, field, getter, parentPath);
            String propertyPath = parentPath + "." + field.getName();
            propertiesWithNonDefaultValues.addAll(this.identifyNonDefaultProperties(defaultFieldValue, actualFieldValue, propertyPath, this.isDeprecated(field, isAncestorDeprecated), this.isDocumented(field, isAncestorDocumented), this.isSensitiveData(field, isAncestorSensitiveData)));
        }
        return propertiesWithNonDefaultValues;
    }

    private Object getValue(Object cdsProperties, Field field, Optional<Method> getter, String parentPath) {
        if (getter.isPresent() && cdsProperties != null) {
            try {
                return getter.get().invoke(cdsProperties, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("Exception while handling property '{}': {}", (Object)(parentPath + field.getName()), (Object)e.getMessage());
            }
        }
        logger.trace("Could not find getter for field '{}.{}'.", (Object)parentPath, (Object)field.getName());
        return null;
    }

    private Optional<Method> findGetter(Field field, Class<?> cdsPropertiesClass) {
        String fieldName = field.getName().replace("_", "").toLowerCase();
        return Arrays.stream(cdsPropertiesClass.getDeclaredMethods()).filter(method -> {
            String methodName = method.getName().toLowerCase();
            return methodName.equals("get" + fieldName) || methodName.equals("is" + fieldName);
        }).findFirst();
    }

    private boolean needsUnwrapping(Object defaultValue, Object actualValue) {
        if (defaultValue != null) {
            return this.isCdsPropertyClass(defaultValue) || defaultValue instanceof List || defaultValue instanceof Map;
        }
        if (actualValue != null) {
            return this.isCdsPropertyClass(actualValue) || actualValue instanceof List || actualValue instanceof Map;
        }
        return false;
    }

    private boolean isCdsPropertyClass(Object actualValue) {
        return actualValue.getClass().getName().startsWith(CdsProperties.class.getName());
    }

    private boolean isDocumented(Field field, boolean isAncestorDocumented) {
        DocumentedProperty documentedProperty = field.getAnnotation(DocumentedProperty.class);
        return isAncestorDocumented && (documentedProperty == null || documentedProperty.value());
    }

    private boolean isDeprecated(Field field, boolean isAncestorDeprecated) {
        return isAncestorDeprecated || field.getAnnotation(Deprecated.class) != null;
    }

    private boolean isSensitiveData(Field field, boolean isAncestorSensitiveData) {
        DocumentedProperty documentedProperty = field.getAnnotation(DocumentedProperty.class);
        return isAncestorSensitiveData || documentedProperty != null && documentedProperty.sensitive();
    }
}

