/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.impl.auditlog.PersonalDataUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.TenantAwareCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

class PersonalDataCaches {
    private final TenantAwareCache<Map<String, PersonalDataMeta>, CdsModel> metaCache;
    private final TenantAwareCache<Map<String, PersonalDataUtils>, CdsModel> utilsCache;

    PersonalDataCaches(CdsRuntime runtime) {
        this.metaCache = TenantAwareCache.create(() -> new ConcurrentHashMap(), (CdsRuntime)runtime);
        this.utilsCache = TenantAwareCache.create(() -> new ConcurrentHashMap(), (CdsRuntime)runtime);
    }

    PersonalDataMeta getMeta(CdsStructuredType type) {
        if (StringUtils.isNotEmpty((CharSequence)type.getQualifiedName())) {
            return ((Map)this.metaCache.findOrCreate()).computeIfAbsent(type.getQualifiedName(), key -> new PersonalDataMeta(type));
        }
        return null;
    }

    PersonalDataUtils getUtils(CdsStructuredType type) {
        if (StringUtils.isNotEmpty((CharSequence)type.getQualifiedName())) {
            return ((Map)this.utilsCache.findOrCreate()).computeIfAbsent(type.getQualifiedName(), key -> new PersonalDataUtils(type, this));
        }
        return null;
    }
}

