/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

class ReferenceAssociationTraverser {
    static final Predicate<CdsElement> NO_COMPOSITIONS = e -> {
        CdsAssociationType type = (CdsAssociationType)e.getType().as(CdsAssociationType.class);
        return !type.isComposition() && !type.isEnclosed();
    };

    private ReferenceAssociationTraverser() {
    }

    static List<CqnReference.Segment> modify(CdsStructuredType root, CqnReference reference, Predicate<CdsElement> takeIf, Function<ResolvedSegment, CqnReference.Segment> action) {
        ArrayList<CqnReference.Segment> result = new ArrayList<CqnReference.Segment>(reference.segments());
        ListIterator<CqnReference.Segment> iterator = result.listIterator();
        if (iterator.hasNext()) {
            RefSegmentImpl next;
            if (reference.firstSegment().equals(root.getQualifiedName())) {
                next = new RefSegmentImpl((CqnReference.Segment)iterator.next(), root, null);
                iterator.set(action.apply(next));
            } else {
                next = new RefSegmentImpl(null, root, null);
            }
            while (iterator.hasNext()) {
                next = ReferenceAssociationTraverser.traverseSegment(next, iterator, takeIf, p -> iterator.set((CqnReference.Segment)action.apply((ResolvedSegment)p)));
            }
        }
        return result;
    }

    static void consume(CdsStructuredType root, CqnReference reference, Predicate<CdsElement> takeIf, Consumer<ResolvedSegment> action) {
        Iterator<CqnReference.Segment> iterator = reference.segments().iterator();
        if (iterator.hasNext()) {
            RefSegmentImpl next;
            if (reference.firstSegment().equals(root.getQualifiedName())) {
                next = new RefSegmentImpl((CqnReference.Segment)iterator.next(), root, null);
                action.accept(next);
            } else {
                next = new RefSegmentImpl(null, root, null);
            }
            while (iterator.hasNext()) {
                next = ReferenceAssociationTraverser.traverseSegment(next, iterator, takeIf, action);
            }
        }
    }

    private static ResolvedSegment traverseSegment(ResolvedSegment current, Iterator<CqnReference.Segment> iterator, Predicate<CdsElement> takeIf, Consumer<ResolvedSegment> action) {
        CqnReference.Segment segment = iterator.next();
        if ("$outer".equals(segment.id())) {
            return current;
        }
        Optional element = current.type().findElement(segment.id());
        if (element.filter(e -> e.getType().isAssociation() && takeIf.test((CdsElement)e)).isPresent()) {
            current = new RefSegmentImpl(segment, (CdsStructuredType)((CdsAssociationType)((CdsElement)element.get()).getType().as(CdsAssociationType.class)).getTarget(), (CdsElement)element.get());
            action.accept(current);
        }
        return current;
    }

    private record RefSegmentImpl(CqnReference.Segment segment, CdsStructuredType type, CdsElement element) implements ResolvedSegment
    {
        private static final Map<String, Object> EMPTY_MAP = Map.of();

        public Map<String, Object> keys() {
            return EMPTY_MAP;
        }

        public Map<String, Object> keyValues() {
            return EMPTY_MAP;
        }

        public Map<String, Object> values() {
            return EMPTY_MAP;
        }
    }
}

