/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.AuthorizationEntity;
import com.sap.cds.services.impl.authorization.StaticAuthorizationsDeepChecker;
import com.sap.cds.services.impl.draft.ParentEntityLookup;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class StaticAuthorizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StaticAuthorizationHandler.class);
    private final TenantAwareCache<ParentEntityLookup, CdsModel> parentEntityLookups;
    private final boolean authorizeDeeply;
    private final AuthorizationService authService;

    public StaticAuthorizationHandler(CdsRuntime runtime) {
        this.parentEntityLookups = TenantAwareCache.create(() -> new ParentEntityLookup(RequestContext.getCurrent((CdsRuntime)runtime).getModel()), (CdsRuntime)runtime);
        this.authorizeDeeply = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthorization().getDeep().isEnabled();
        this.authService = (AuthorizationService)runtime.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
    }

    @Before(event={"*"})
    @HandlerOrder(value=-10800)
    private void checkStaticAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged()) {
            this.checkStaticAuthorizationOrThrow(context);
        }
    }

    private void checkStaticAuthorizationOrThrow(EventContext context) {
        String actionOrFunctionName;
        String event = context.getEvent();
        String serviceName = ((ApplicationService)context.getService()).getDefinition().getQualifiedName();
        if (!this.authService.hasServiceAccess(serviceName, event)) {
            StaticAuthorizationHandler.throwAuthorizationError(context, event, serviceName);
        }
        CdsEntity targetEntity = context.getTarget();
        String entityName = null;
        if (targetEntity != null) {
            String authorizationEntityName;
            AuthorizationEntity authEntity;
            entityName = targetEntity.getQualifiedName();
            CqnStatement query = null;
            Object cqn = context.get("cqn");
            if (cqn instanceof CqnStatement) {
                CqnStatement statement;
                query = statement = (CqnStatement)cqn;
            }
            if ((authEntity = AuthorizationEntity.resolve(context, entity -> ((ParentEntityLookup)this.parentEntityLookups.findOrCreate()).lookupParent((CdsEntity)entity))).getAuthorizationEntity() == null) {
                logger.debug("No authorization entity found when sending event '{}' to entity '{}'", (Object)event, (Object)entityName);
                StaticAuthorizationHandler.throwAuthorizationError(context, event, entityName);
            }
            if (!this.authService.hasEntityAccess(authorizationEntityName = authEntity.getAuthorizationEntity().getQualifiedName(), event, query)) {
                StaticAuthorizationHandler.throwAuthorizationError(context, event, entityName);
            }
            if (this.authorizeDeeply && query != null) {
                List<String> alreadyChecked = List.of(entityName, authorizationEntityName);
                CqnVisitor visitor = this.newDeepAuthorizationChecker(context, query, alreadyChecked);
                if (query.isSelect()) {
                    query.asSelect().accept(visitor);
                } else if (query.isInsert()) {
                    query.asInsert().ref().accept(visitor);
                } else if (query.isUpsert()) {
                    query.asUpsert().ref().accept(visitor);
                } else if (query.isUpdate()) {
                    CqnUpdate update = query.asUpdate();
                    update.ref().accept(visitor);
                    update.where().ifPresent(w -> w.accept(visitor));
                } else if (query.isDelete()) {
                    CqnDelete delete = query.asDelete();
                    delete.ref().accept(visitor);
                    delete.where().ifPresent(w -> w.accept(visitor));
                }
            }
            if (!this.authorizationEntityCondition(context, entityName, authEntity)) {
                StaticAuthorizationHandler.throwAuthorizationError(context, event, entityName);
            }
        }
        String string = actionOrFunctionName = targetEntity == null ? serviceName + "." + event : event;
        if (!CdsModelUtils.isStandardCdsEvent(event)) {
            if (CdsModelUtils.getAction(context.getModel(), entityName, actionOrFunctionName).isPresent() && !this.authService.hasActionAccess(entityName, actionOrFunctionName)) {
                StaticAuthorizationHandler.throwAuthorizationError(context, actionOrFunctionName, entityName != null ? entityName : serviceName);
            } else if (CdsModelUtils.getFunction(context.getModel(), entityName, actionOrFunctionName).isPresent() && !this.authService.hasFunctionAccess(entityName, actionOrFunctionName)) {
                StaticAuthorizationHandler.throwAuthorizationError(context, actionOrFunctionName, entityName != null ? entityName : serviceName);
            }
        }
        logger.debug("Static authorization check passed for event '{}' on service '{}'", (Object)event, (Object)serviceName);
    }

    private CqnVisitor newDeepAuthorizationChecker(EventContext context, CqnStatement statement, Collection<String> alreadyChecked) {
        return new StaticAuthorizationsDeepChecker(context, statement, alreadyChecked, entity -> {
            String entityName = entity.getQualifiedName();
            if (!this.authService.hasEntityAccess(entityName, "READ")) {
                logger.debug("Deep Authorization: user is not allowed to access entity '{}'", (Object)entityName);
                StaticAuthorizationHandler.throwAuthorizationError(context, "READ", entityName);
            }
        });
    }

    private static void throwAuthorizationError(EventContext context, String event, String elementName) {
        if (context.getUserInfo().isAuthenticated()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN, new Object[]{event, elementName});
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_UNAUTHENTICATED, new Object[]{event, elementName});
    }

    private boolean authorizationEntityCondition(EventContext context, String entityName, AuthorizationEntity authEntity) {
        if (authEntity.getAuthorizationPath() != null && !entityName.equals(authEntity.getAuthorizationEntity().getQualifiedName()) && authEntity.authorizationCondition(context.getEvent()) != null && !authEntity.isDraft()) {
            ChangeSetContextSPI changeSetContext = (ChangeSetContextSPI)context.getChangeSetContext();
            if (changeSetContext == null || !changeSetContext.hasChangeSetMember("PersistenceService$Default")) {
                return (Boolean)context.getCdsRuntime().changeSetContext().run(c -> this.authorizationEntityConditionImpl(context, authEntity));
            }
            return this.authorizationEntityConditionImpl(context, authEntity);
        }
        return true;
    }

    private boolean authorizationEntityConditionImpl(EventContext context, AuthorizationEntity authEntity) {
        CqnPredicate authorizationCondition = authEntity.authorizationCondition(context.getEvent());
        if (authorizationCondition != null) {
            Select readTest = Select.from((CqnStructuredTypeRef)authEntity.getAuthorizationPath()).where(authorizationCondition);
            if (CdsServiceUtils.getDefaultPersistenceService(context).run((CqnSelect)readTest, new Object[0]).first().isEmpty()) {
                logger.debug("No authorization to send event '{}' to entity '{}' because of instance '{}'", new Object[]{context.getEvent(), authEntity.getAuthorizationEntity().getQualifiedName(), authEntity.getAuthorizationPath()});
                return false;
            }
        }
        return true;
    }
}

