/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.changeset;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.changeset.ChangeSetMember;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetContextImpl
implements ChangeSetContextSPI {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetContextImpl.class);
    private static final AtomicInteger idProvider = new AtomicInteger();
    private boolean isTransactional;
    private boolean markedForCancel;
    private boolean isClosed;
    private final int id;
    private final boolean shadow;
    private List<ChangeSetListener> listeners = new ArrayList<ChangeSetListener>();
    private LinkedList<ChangeSetMember> members = new LinkedList();
    private static final ThreadLocal<Stack<ChangeSetContextImpl>> changeSetContexts = ThreadLocal.withInitial(() -> new Stack());

    private ChangeSetContextImpl(boolean shadow, boolean isTransactional) {
        this.id = idProvider.incrementAndGet();
        this.shadow = shadow;
        this.isTransactional = isTransactional;
    }

    public static ChangeSetContextImpl open(boolean isTransactional) {
        return ChangeSetContextImpl.initChangeSetContext(false, isTransactional);
    }

    public static ChangeSetContextImpl attach() {
        return ChangeSetContextImpl.initChangeSetContext(true, true);
    }

    private static ChangeSetContextImpl initChangeSetContext(boolean shadow, boolean isTransactional) {
        ChangeSetContextImpl changeSetContext = new ChangeSetContextImpl(shadow, isTransactional);
        changeSetContexts.get().push(changeSetContext);
        logger.debug("Opened {}ChangeSet {}", (Object)(shadow ? "shadow " : ""), (Object)changeSetContext.getId());
        return changeSetContext;
    }

    public static ChangeSetContextSPI getCurrent() {
        Stack<ChangeSetContextImpl> stack = changeSetContexts.get();
        return stack.isEmpty() ? null : (ChangeSetContextSPI)stack.peek();
    }

    public int getId() {
        return this.id;
    }

    public boolean isMarkedTransactional() {
        return this.isTransactional;
    }

    public void markTransactional() {
        this.isTransactional = true;
    }

    public void register(ChangeSetListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void register(ChangeSetMember member) {
        if (this.shadow && !this.members.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_CHANGE_SET_MEMBERS, new Object[]{this.id});
        }
        if (this.members.stream().anyMatch(m -> Objects.equals(m.getName(), member.getName())) || this.members.contains(member)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DUPLICATE_CHANGE_SET_MEMBERS, new Object[]{member.getName(), this.id});
        }
        this.members.addFirst(member);
    }

    public boolean hasChangeSetMember(String name) {
        return this.members.stream().anyMatch(member -> member.getName().equals(name));
    }

    public void triggerBeforeClose() {
        try {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).beforeClose();
            }
        }
        catch (Exception e) {
            this.markForCancel();
            logger.info("Exception in listener marked the ChangeSet {} as cancelled: {}", (Object)this.getId(), (Object)e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ChangeSetListener[] listenersCopy;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        ServiceException rejectException = null;
        ErrorStatusException closeException = null;
        try {
            if (!this.shadow) {
                ChangeSetMember[] membersCopy;
                try {
                    this.triggerBeforeClose();
                }
                catch (ServiceException e) {
                    rejectException = e;
                }
                catch (Exception e) {
                    rejectException = new ServiceException((Throwable)e);
                }
                for (ChangeSetMember member : membersCopy = this.members.toArray(new ChangeSetMember[0])) {
                    if (!member.isMarkedForCancel()) continue;
                    this.markForCancel();
                    logger.info("Rollback only status in member {} marked the ChangeSet {} as cancelled", (Object)member.getName(), (Object)this.getId());
                }
                boolean markedForCancel = this.isMarkedForCancel();
                logger.debug("{} ChangeSet {}", (Object)(markedForCancel ? "Cancelling" : "Completing"), (Object)this.getId());
                ChangeSetMember[] changeSetMemberArray = membersCopy;
                int n = changeSetMemberArray.length;
                for (int member = 0; member < n; ++member) {
                    ChangeSetMember member2 = changeSetMemberArray[member];
                    try {
                        if (markedForCancel) {
                            member2.cancel();
                            continue;
                        }
                        member2.complete();
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Unexpected exception during {} of member {} in ChangeSet {}: {}", new Object[]{markedForCancel ? "cancelation" : "completion", member2.getName(), this.getId(), e.getMessage(), e});
                        if (closeException != null) continue;
                        closeException = markedForCancel ? new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CHANGESET_CANCELATION_FAILED, new Object[]{member2.getName(), this.getId(), e}) : new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CHANGESET_COMPLETION_FAILED, new Object[]{member2.getName(), this.getId(), e});
                    }
                }
            }
            changeSetContexts.get().pop();
        }
        catch (Throwable throwable) {
            changeSetContexts.get().pop();
            logger.debug("Closed {}ChangeSet {}", (Object)(this.shadow ? "shadow " : ""), (Object)this.getId());
            throw throwable;
        }
        logger.debug("Closed {}ChangeSet {}", (Object)(this.shadow ? "shadow " : ""), (Object)this.getId());
        for (ChangeSetListener listener : listenersCopy = this.listeners.toArray(new ChangeSetListener[0])) {
            try {
                listener.afterClose(!this.markedForCancel && closeException == null);
            }
            catch (Exception e) {
                logger.error("Unexpected exception during afterClose of ChangeSet {}: {}", new Object[]{this.getId(), e.getMessage(), e});
            }
        }
        if (closeException != null) {
            throw closeException;
        }
        if (rejectException != null) {
            throw rejectException;
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public void markForCancel() {
        this.markedForCancel = true;
    }

    public boolean isMarkedForCancel() {
        return this.markedForCancel;
    }
}

