/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.impl.builder.model.InPredicate;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.impl.draft.DraftHandlerUtils;
import com.sap.cds.services.impl.draft.DraftInactivesReader;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class DraftActivesReader {
    private static final String DRAFT_ADMINISTRATIVE_DATA_CREATED_BY_USER = "DraftAdministrativeData.CreatedByUser";
    private static final String DRAFT_ADMINISTRATIVE_DATA_LAST_CHANGE_DATE_TIME = "DraftAdministrativeData.LastChangeDateTime";
    private final EventContext context;
    private final DraftInactivesReader inactivesReader;

    public static DraftActivesReader create(EventContext context) {
        return new DraftActivesReader(context);
    }

    private DraftActivesReader(EventContext context) {
        this.context = context;
        this.inactivesReader = DraftInactivesReader.create(context);
    }

    public Result allActives(CqnSelect select, Map<String, Object> cqnNamedValues, CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef) {
        ActiveSanitizer sanitizer = new ActiveSanitizer(remainingWhere, remainingRef, this.context.getTarget(), select.excluding());
        CqnSelect sanitizedSelect = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)sanitizer);
        Result result = DraftServiceImpl.downcast(this.context.getService()).readActive(sanitizedSelect, cqnNamedValues);
        if (result.rowCount() > 0L) {
            List drafts = !sanitizer.getDraftItems().isEmpty() ? this.inactivesReader.draftsOfAllUsers((CqnSelect)Select.from((CdsEntity)this.context.getTarget()).columns(sanitizer.getDraftItems()).where(this.matchingKeys(result))).list() : Collections.emptyList();
            DraftActivesReader.traverse(result.list(), drafts, this.context.getTarget(), sanitizer.getSelectionTree());
        }
        return result;
    }

    public Result withoutDrafts(CqnSelect select, Map<String, Object> cqnNamedValues, CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef) {
        Result drafts = this.inactivesReader.draftsOfAllUsers((CqnSelect)Select.from((CqnStructuredTypeRef)remainingRef).columns(DraftActivesReader.keys(this.context.getTarget()).toArray(new String[0])).where((CqnPredicate)CQL.get((String)"HasActiveEntity").eq((Object)true).and(remainingWhere, new CqnPredicate[0])).search((CqnPredicate)select.search().orElse(null)));
        ActiveSanitizer sanitizer = new ActiveSanitizer(remainingWhere, remainingRef, this.context.getTarget(), select.excluding());
        SelectBuilder sanitizedSelect = SelectBuilder.copy((CqnSelect)select, (Modifier)sanitizer).filter((CqnPredicate)CQL.not((CqnPredicate)this.matchingKeys(drafts)));
        Result result = DraftServiceImpl.downcast(this.context.getService()).readActive((CqnSelect)sanitizedSelect, cqnNamedValues);
        DraftActivesReader.traverse(result.list(), Collections.emptyList(), this.context.getTarget(), sanitizer.getSelectionTree());
        return result;
    }

    public Result withDraftsFromOtherUsers(CqnSelect select, Map<String, Object> cqnNamedValues, CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef, boolean locked) {
        ActiveSanitizer sanitizer = new ActiveSanitizer(remainingWhere, remainingRef, this.context.getTarget(), select.excluding());
        SelectBuilder sanitizedSelect = SelectBuilder.copy((CqnSelect)select, (Modifier)sanitizer);
        Result drafts = this.inactivesReader.draftsOfAllUsers((CqnSelect)Select.from((CqnStructuredTypeRef)remainingRef).columns(DraftActivesReader.addIfMissing(sanitizer.getDraftItems(), DraftActivesReader.keys(this.context.getTarget()))).where((CqnPredicate)CQL.and((CqnPredicate)remainingWhere, (CqnPredicate)CQL.get((String)"HasActiveEntity").eq((Object)true).and(DraftActivesReader.ownedbyAnotherUser(locked, this.context), new CqnPredicate[0]))).search((CqnPredicate)select.search().orElse(null)).orderBy(select.orderBy()).limit(select.top(), select.skip()));
        if (drafts.rowCount() > 0L) {
            Select selectActivesFromDrafts = sanitizedSelect.filter(this.matchingKeys(drafts)).limit(-1L);
            Result result = DraftServiceImpl.downcast(this.context.getService()).readActive((CqnSelect)selectActivesFromDrafts, cqnNamedValues);
            DraftActivesReader.traverse(result.list(), drafts.list(), this.context.getTarget(), sanitizer.getSelectionTree());
            return result;
        }
        return DraftHandlerUtils.buildNoOpResult(this.context);
    }

    public static CqnPredicate ownedbyAnotherUser(boolean locked, EventContext context) {
        return CQL.and(List.of(CQL.get((String)DRAFT_ADMINISTRATIVE_DATA_CREATED_BY_USER).isNotNull(), CQL.get((String)DRAFT_ADMINISTRATIVE_DATA_CREATED_BY_USER).ne((Object)CQL.userId()), CQL.comparison((CqnValue)CQL.get((String)DRAFT_ADMINISTRATIVE_DATA_LAST_CHANGE_DATE_TIME), (CqnComparisonPredicate.Operator)(locked ? CqnComparisonPredicate.Operator.GT : CqnComparisonPredicate.Operator.LE), (CqnValue)CQL.constant((Object)DraftModifier.getCancellationThreshold(context)))));
    }

    CqnPredicate matchingKeys(Result result) {
        List<String> keyElements = DraftActivesReader.keys(this.context.getTarget());
        return InPredicate.in(keyElements, (Collection)result.list());
    }

    private static void traverse(List<? extends Map<String, Object>> rows, List<? extends Map<String, Object>> drafts, CdsEntity entity, SelectionNode node) {
        List<String> keyElements = DraftActivesReader.keys(entity);
        for (Map<String, Object> map : rows) {
            Map<String, Object> matchingDraft = null;
            if (!drafts.isEmpty()) {
                HashMap<String, Object> keys = new HashMap<String, Object>(keyElements.size());
                keyElements.forEach(key -> keys.put((String)key, row.get(key)));
                matchingDraft = DraftActivesReader.findMatching(drafts, keys);
            }
            if (node.draftElements().contains("IsActiveEntity")) {
                map.put("IsActiveEntity", true);
            }
            if (node.draftElements().contains("HasActiveEntity")) {
                map.put("HasActiveEntity", false);
            }
            if (node.draftElements().contains("HasDraftEntity")) {
                map.put("HasDraftEntity", matchingDraft != null);
            }
            if (node.draftElements().contains("DraftAdministrativeData")) {
                map.put("DraftAdministrativeData", matchingDraft != null ? matchingDraft.get("DraftAdministrativeData") : null);
            }
            if (node.draftElements().contains("DraftAdministrativeData_DraftUUID")) {
                map.put("DraftAdministrativeData_DraftUUID", matchingDraft != null ? matchingDraft.get("DraftAdministrativeData_DraftUUID") : null);
            }
            for (SelectionNode childNode : node.children()) {
                List<? extends Map<String, Object>> childRows = DraftActivesReader.toList(map.get(childNode.elementName()));
                if (childRows.isEmpty()) continue;
                List childDraftRows = matchingDraft != null ? DraftActivesReader.toList(matchingDraft.get(childNode.elementName())) : Collections.emptyList();
                DraftActivesReader.traverse(childRows, childDraftRows, (CdsEntity)entity.getTargetOf(childNode.elementName()), childNode);
            }
        }
    }

    private static Map<String, Object> findMatching(List<? extends Map<String, Object>> drafts, Map<String, Object> keys) {
        Map<String, Object> matchingDraft = null;
        for (Map<String, Object> map : drafts) {
            if (!map.entrySet().containsAll(keys.entrySet())) continue;
            matchingDraft = map;
            break;
        }
        return matchingDraft;
    }

    static List<String> keys(CdsEntity entity) {
        return com.sap.cds.util.CdsModelUtils.keyNames((CdsStructuredType)entity).stream().filter(k -> !k.equals("IsActiveEntity")).toList();
    }

    private static List<CqnSelectListItem> addIfMissing(List<CqnSelectListItem> items, List<String> itemsToAdd) {
        Set contained = items.stream().flatMap(CqnSelectListItem::ofRef).map(CqnReference::path).collect(Collectors.toSet());
        itemsToAdd.stream().filter(i -> !contained.contains(i)).map(CQL::get).forEach(items::add);
        return items;
    }

    private static List<? extends Map<String, Object>> toList(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        return Collections.emptyList();
    }

    private static class ActiveSanitizer
    implements Modifier {
        private final CqnPredicate remainingWhere;
        private final CqnStructuredTypeRef remainingRef;
        private final CdsEntity target;
        private final List<String> targetExcluding;
        private final SelectionNode selectionTree = new SelectionNode(null);
        private List<CqnSelectListItem> draftItems;

        public ActiveSanitizer(CqnPredicate remainingWhere, CqnStructuredTypeRef remainingRef, CdsEntity target, List<String> targetExcluding) {
            this.remainingWhere = remainingWhere;
            this.remainingRef = remainingRef;
            this.target = target;
            this.targetExcluding = targetExcluding;
        }

        public SelectionNode getSelectionTree() {
            return this.selectionTree;
        }

        public List<CqnSelectListItem> getDraftItems() {
            return this.draftItems;
        }

        public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
            return this.remainingRef != null ? this.remainingRef : ref;
        }

        public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
            Items pair = this.splitItems(items, this.target, this.targetExcluding, this.selectionTree);
            this.draftItems = pair.draftItems();
            return pair.items();
        }

        private Items splitItems(List<CqnSelectListItem> items, CdsEntity entity, List<String> excluding, SelectionNode node) {
            items = CqnStatementUtils.resolveStar(items, excluding, (CdsStructuredType)entity, (boolean)false);
            ArrayList<CqnSelectListItem> nonDraft = new ArrayList<CqnSelectListItem>(items.size());
            ArrayList<CqnSelectListItem> draft = new ArrayList<CqnSelectListItem>(3);
            boolean keysRequired = false;
            for (CqnSelectListItem item : items) {
                if (item.isRef()) {
                    String path = item.asRef().path();
                    if (Drafts.ELEMENTS.contains(path)) {
                        node.draftElements().add(path);
                        if ("DraftAdministrativeData".equals(path) || "DraftAdministrativeData_DraftUUID".equals(path)) {
                            draft.add(item);
                            keysRequired = true;
                            continue;
                        }
                        if (!"HasDraftEntity".equals(path)) continue;
                        keysRequired = true;
                        continue;
                    }
                    nonDraft.add(item);
                    continue;
                }
                if (item.isExpand()) {
                    CqnExpand expand = item.asExpand();
                    String path = expand.ref().path();
                    if ("DraftAdministrativeData".equals(path)) {
                        node.draftElements().add("DraftAdministrativeData");
                        draft.add((CqnSelectListItem)expand);
                        keysRequired = true;
                        continue;
                    }
                    SelectionNode expandNode = new SelectionNode(path);
                    Items pair = this.splitItems(expand.items(), CdsModelUtils.getRefTarget((CqnStructuredTypeRef)expand.ref(), (CdsEntity)entity), Collections.emptyList(), expandNode);
                    List<CqnSortSpecification> sortSpecs = this.orderBy(expand.orderBy());
                    if (!pair.items().isEmpty()) {
                        nonDraft.add((CqnSelectListItem)CQL.copy((CqnExpand)expand).items(pair.items()).orderBy(sortSpecs));
                    }
                    if (!pair.draftItems().isEmpty()) {
                        draft.add((CqnSelectListItem)CQL.copy((CqnExpand)expand).items(pair.draftItems()).orderBy(sortSpecs));
                    }
                    if (!expandNode.children().isEmpty() || !expandNode.draftElements().isEmpty()) {
                        node.children().add(expandNode);
                    }
                    if (!pair.keysRequired()) continue;
                    keysRequired = true;
                    continue;
                }
                nonDraft.add(item);
            }
            if (keysRequired) {
                List<String> keys = DraftActivesReader.keys(entity);
                DraftActivesReader.addIfMissing(nonDraft, keys);
                keys.stream().map(CQL::get).forEach(draft::add);
            }
            return new Items(nonDraft, draft, keysRequired);
        }

        public CqnPredicate where(Predicate where) {
            return this.remainingWhere != null ? this.remainingWhere : where;
        }

        public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> sortSpecs) {
            return sortSpecs.stream().filter(s -> !s.value().isRef() || !s.value().asRef().path().equals("IsActiveEntity")).toList();
        }

        private record Items(List<CqnSelectListItem> items, List<CqnSelectListItem> draftItems, boolean keysRequired) {
        }
    }

    private record SelectionNode(String elementName, Set<String> draftElements, List<SelectionNode> children) {
        public SelectionNode(String elementName) {
            this(elementName, new HashSet<String>(), new ArrayList<SelectionNode>());
        }
    }
}

