/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.draft.DraftGcEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.model.DynamicModelProvider;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.OpenTelemetryUtils;
import com.sap.cds.services.utils.TenantAwareCache;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class DraftGCHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DraftGCHandler.class);
    private static final int THREAD_POOL_SIZE = 1;
    private final ExecutorService gcExecutor;
    private final TenantAwareCache<Map<String, Instant>, Boolean> lastGcs;
    private final CdsRuntime runtime;
    private Timer timer;

    public DraftGCHandler(CdsRuntime runtime) {
        this.runtime = runtime;
        this.gcExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("draft-gc-exec-%d").setDaemon(true).build());
        this.lastGcs = TenantAwareCache.create(() -> RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo().getTenant(), ConcurrentHashMap::new, () -> Boolean.TRUE);
    }

    @On
    protected void initializeGC(ApplicationPreparedEventContext context) {
        if (this.runtime.getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        CdsProperties.Drafts.GC gcConfig = this.runtime.getEnvironment().getCdsProperties().getDrafts().getGc();
        if (gcConfig.isEnabled().booleanValue() && this.timer == null) {
            this.timer = new Timer("Draft GC Timer", true);
            long gcInterval = gcConfig.getInterval().toMillis();
            long firstExecutionTime = ThreadLocalRandom.current().nextLong(gcInterval);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DraftGCHandler.this.gcAll();
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to gc drafts", t);
                    }
                }
            }, firstExecutionTime, gcInterval);
        }
    }

    @On
    protected void stopGC(ApplicationStoppedEventContext context) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @After(service={"*"}, serviceType={DraftService.class})
    protected void afterDraftSave(DraftSaveEventContext context) {
        CdsProperties.Drafts.GC gcConfig = context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getGc();
        if (gcConfig.isEnabled().booleanValue()) {
            String tenant = context.getUserInfo().getTenant();
            this.gcExecutor.execute(() -> {
                DraftService draftService;
                Instant now = Instant.now();
                if (this.readyForGc(now, draftService = context.getService(), gcConfig.getInterval())) {
                    try {
                        context.getCdsRuntime().requestContext().systemUser(tenant).privilegedUser().run(reqContext -> {
                            ((Map)this.lastGcs.findOrCreate()).put(draftService.getName(), now);
                            draftService.gcDrafts();
                        });
                    }
                    catch (Exception e) {
                        LOG.error("An error occurred while executing draft gc for tenant '{}' and service '{}' after draft save", new Object[]{tenant, draftService.getName(), e});
                    }
                }
            });
        }
    }

    @On(service={"*"}, serviceType={DraftService.class})
    @HandlerOrder(value=11000)
    protected void onGcDrafts(DraftGcEventContext context) {
        Optional span = OpenTelemetryUtils.createSpan((OpenTelemetryUtils.CdsSpanType)OpenTelemetryUtils.CdsSpanType.DRAFT_GC, (SpanKind)SpanKind.SERVER);
        try (Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);){
            span.ifPresent(s -> {
                s.updateName("Draft GC (" + context.getService().getName() + ")");
                s.setAttribute(OpenTelemetryUtils.CDS_TENANT, (Object)context.getUserInfo().getTenant());
                s.setAttribute(OpenTelemetryUtils.CDS_SERVICE, (Object)context.getService().getName());
            });
            Instant threshold = DraftGCHandler.getAgeThreshold(context.getCdsRuntime().getEnvironment().getCdsProperties());
            DraftService draftService = context.getService();
            AtomicLong numCancelledDrafts = new AtomicLong(0L);
            context.getCdsRuntime().requestContext().privilegedUser().run(ctx -> draftService.getDefinition().entities().forEach(e -> {
                Delete deleteOldDrafts;
                Result result;
                if (DraftUtils.isDraftRoot((CdsAnnotatable)e) && !e.getQualifiedName().endsWith("_drafts") && (result = draftService.cancelDraft((CqnDelete)(deleteOldDrafts = Delete.from((CdsEntity)e).where(c -> c.get("IsActiveEntity").eq((Object)false).and((CqnPredicate)c.to("DraftAdministrativeData").anyMatch(a -> a.get("LastChangeDateTime").le((Object)threshold)), new CqnPredicate[0]))), new Object[0])).rowCount() > 0L) {
                    LOG.debug("Draft GC deleted {} drafts of entity '{}'", (Object)result.rowCount(), (Object)e.getQualifiedName());
                    numCancelledDrafts.addAndGet(result.rowCount());
                }
            }));
            long cancelledDrafts = numCancelledDrafts.get();
            if (cancelledDrafts > 0L) {
                LOG.info("Draft GC deleted {} drafts of service '{}'", (Object)cancelledDrafts, (Object)draftService.getName());
            }
            context.setResult(ResultBuilder.deletedRows((long)cancelledDrafts).result());
        }
        catch (Exception e) {
            OpenTelemetryUtils.recordException((Optional)span, (Exception)e);
            throw e;
        }
        finally {
            OpenTelemetryUtils.endSpan((Optional)span);
        }
    }

    protected void gcAll() {
        ServiceCatalog serviceCatalog = this.runtime.getServiceCatalog();
        CdsProperties.Drafts.GC gc = this.runtime.getEnvironment().getCdsProperties().getDrafts().getGc();
        Duration maxPause = gc.getMaxPause();
        Duration gcInterval = gc.getInterval();
        Instant ageThreshold = DraftGCHandler.getAgeThreshold(this.runtime.getEnvironment().getCdsProperties());
        List tenants = (List)this.runtime.requestContext().systemUserProvider().run(r -> {
            TenantProviderService tenantProvider = (TenantProviderService)r.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
            return tenantProvider.readTenants();
        });
        Collections.shuffle(tenants);
        List draftServices = serviceCatalog.getServices(DraftService.class).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(draftServices);
        tenants.forEach(tenant -> {
            try {
                ArrayList servicesToGc = new ArrayList();
                draftServices.forEach(draftService -> {
                    Instant now = Instant.now();
                    if (this.readyForGc(now, (DraftService)draftService, gcInterval)) {
                        ((Map)this.lastGcs.findOrCreate()).put(draftService.getName(), now);
                        servicesToGc.add(draftService);
                    }
                });
                if (!servicesToGc.isEmpty()) {
                    if (DraftGCHandler.hasAnyDraftsOlderThanThreshold(this.runtime, tenant, ageThreshold)) {
                        LOG.debug("Executing draft GC for tenant {}", tenant);
                        this.runtime.requestContext().systemUser(tenant).privilegedUser().run(ctx -> servicesToGc.forEach(DraftService::gcDrafts));
                    }
                    TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextLong(maxPause.toMillis()));
                }
            }
            catch (InterruptedException ie) {
                LOG.debug("Draft GC timer thread '{}' interrupted", (Object)Thread.currentThread().getName(), (Object)ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                CdsCommunicationException cdsCommunicationException;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof CdsCommunicationException && (cdsCommunicationException = (CdsCommunicationException)rootCause).getHttpStatusCode() == 404) {
                    LOG.debug("Skipped draft GC for nonexistent tenant '{}'", tenant);
                }
                LOG.error("Failed to gc drafts of tenant '{}'", tenant, (Object)e);
            }
        });
    }

    private boolean readyForGc(Instant now, DraftService draftService, Duration gcInterval) {
        Instant lastGc = (Instant)((Map)this.lastGcs.findOrCreate()).get(draftService.getName());
        return lastGc == null || lastGc.plus(gcInterval).isBefore(now);
    }

    private static Instant getAgeThreshold(CdsProperties configuration) {
        return Instant.now().minus(configuration.getDrafts().getDeletionTimeout()).truncatedTo(ChronoUnit.MILLIS);
    }

    private static boolean hasAnyDraftsOlderThanThreshold(CdsRuntime runtime, String tenant, Instant ageThreshold) {
        return (Boolean)runtime.requestContext().featureToggles(DynamicModelProvider.STATIC_MODEL_ACCESS_FEATURE).systemUser(tenant).run(requestContext -> {
            try {
                CqnService persistenceService = (CqnService)requestContext.getServiceCatalog().getService("PersistenceService$Default");
                Result result = persistenceService.run((CqnSelect)Select.from((String)"DRAFT.DraftAdministrativeData").columns(new Selectable[]{CQL.constant((Object)"1").as("ID")}).limit(1L).where((CqnPredicate)CQL.get((String)"LastChangeDateTime").le((Object)ageThreshold)), new Object[0]);
                return result.rowCount() > 0L;
            }
            catch (Exception e) {
                LOG.error("Failed to check if there are drafts older than {} in tenant '{}'. The draft GC will continue to run.", new Object[]{ageThreshold, tenant, e});
                return true;
            }
        });
    }
}

