/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;

public class CqnStatementArgumentResolver
implements ArgumentResolver {
    private final Class<? extends CqnStatement> cqnStatementType;
    private final boolean ref;

    public static CqnStatementArgumentResolver createIfApplicable(Class<?> type) {
        if (CqnStatement.class.isAssignableFrom(type)) {
            return new CqnStatementArgumentResolver(type, false);
        }
        if (CqnStructuredTypeRef.class.equals(type)) {
            return new CqnStatementArgumentResolver(CqnStatement.class, true);
        }
        return null;
    }

    private CqnStatementArgumentResolver(Class<?> type, boolean ref) {
        this.cqnStatementType = type;
        this.ref = ref;
    }

    @Override
    public Object resolve(EventContext context) {
        CqnStatement cqn = this.cqnStatementType.cast(context.get("cqn"));
        return cqn != null && this.ref ? (!cqn.isSelect() || cqn.asSelect().from().isRef() ? cqn.ref() : null) : cqn;
    }

    @Override
    public void verifyOrThrow(HandlerDescriptor descriptor) {
    }
}

