/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.persistence.CsvDataLoader;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class CsvInitializationHandler
implements EventHandler {
    @On
    protected void initializeDatabase(ApplicationPreparedEventContext context) {
        PersistenceService db;
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        CdsProperties.DataSource config = context.getCdsRuntime().getEnvironment().getCdsProperties().getDataSource();
        String csvInitMode = config.getCsv().getInitializationMode();
        if (("always".equals(csvInitMode) || "embedded".equals(csvInitMode) && config.isEmbedded()) && (db = CdsServiceUtils.getDefaultPersistenceService((EventContext)context)) != null) {
            new CsvDataLoader(db, context.getCdsRuntime()).load();
        }
    }
}

