/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.impl.draft.messages.DraftMessageUtils;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class ValidatorExecutor {
    private static final Set<String> crudEvents = Set.of("CREATE", "UPDATE", "UPSERT");
    private static final Set<String> draftValidationEvents = Set.of("DRAFT_NEW", "DRAFT_PATCH");

    private ValidatorExecutor() {
    }

    public static void processEntities(CdsDataProcessor processor, EventContext context) {
        ValidatorExecutor.runValidation(processor, context, () -> CdsServiceUtils.getEntities(context), true);
    }

    static void processResolvedEntities(CdsDataProcessor processor, EventContext context) {
        ValidatorExecutor.runValidation(processor, context, () -> CdsServiceUtils.getEntitiesResolved(context), false);
    }

    private static void runValidation(CdsDataProcessor processor, EventContext context, Supplier<List<Map<String, Object>>> entities, boolean includeDraftNew) {
        if (ValidatorExecutor.isValidationEvent(context, includeDraftNew)) {
            processor.process((Iterable)entities.get(), (CdsStructuredType)context.getTarget());
        } else if (context.getService() instanceof ApplicationService && context.getCdsRuntime().getEnvironment().getCdsProperties().getQuery().getValidation().getParameters().isEnabled().booleanValue() && !CdsModelUtils.isDraftEvent(context.getEvent())) {
            ValidatorExecutor.handleOperationParameters(processor, context);
        }
    }

    public static boolean isValidationEvent(EventContext context, boolean includeDraftNew) {
        return crudEvents.contains(context.getEvent()) || ValidatorExecutor.validateDraft(context, includeDraftNew);
    }

    private static boolean validateDraft(EventContext context, boolean includeDraftNew) {
        return draftValidationEvents.contains(context.getEvent()) && (includeDraftNew || !context.getEvent().equals("DRAFT_NEW")) && DraftMessageUtils.isDraftMessagesEnabled(context.getModel()) && !DraftMessageUtils.isDraftMessagesPatch(context);
    }

    private static void handleOperationParameters(CdsDataProcessor processor, EventContext context) {
        ValidatorExecutor.getOperationAsStructuredType(context).ifPresent(definition -> processor.process((Map)definition.getValue(), (CdsStructuredType)definition.getKey()));
    }

    private static Optional<Pair<CdsStructuredType, Map<String, Object>>> getOperationAsStructuredType(EventContext context) {
        List parameters = ValidatorExecutor.detectOperationParameters(context).map(p -> new CdsElementBuilder(p.annotations().collect(Collectors.toList()), p.getName(), null, false, false, p.isNotNull(), false, p.getDefaultValue().orElse(null), "").type(p.getType())).collect(Collectors.toList());
        if (!parameters.isEmpty()) {
            String typeName = context.getEvent().concat("_internalOperationType");
            CdsStructuredTypeBuilder builder = new CdsStructuredTypeBuilder(Collections.singletonList(CdsAnnotatableImpl.CdsAnnotationImpl.annotation((String)CdsAnnotations.INTERNAL_OPERATION_TYPE.name(), (Object)true)), String.join((CharSequence)".", context.getService().getName(), typeName), typeName, CdsKind.TYPE, "");
            builder.addElements(parameters);
            CdsStructuredType type = builder.build();
            HashMap data = new HashMap();
            type.elements().forEach(e -> data.put(e.getName(), context.get(e.getName())));
            return Optional.of(Pair.of((Object)builder.build(), data));
        }
        return Optional.empty();
    }

    private static Stream<CdsParameter> detectOperationParameters(EventContext context) {
        String operationName;
        String targetName;
        if (context.getTarget() != null) {
            targetName = context.getTarget().getQualifiedName();
            operationName = context.getEvent();
        } else {
            targetName = null;
            operationName = String.join((CharSequence)".", context.getService().getName(), context.getEvent());
        }
        return CdsModelUtils.getFunction(context.getModel(), targetName, operationName).map(CdsOperation::parameters).orElseGet(() -> CdsModelUtils.getAction(context.getModel(), targetName, operationName).map(CdsOperation::parameters).orElseGet(Stream::empty));
    }
}

