/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft.messages;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.Struct;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftAdministrativeData;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.impl.draft.messages.DraftMessage;
import com.sap.cds.services.impl.draft.messages.DraftMessageUtils;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ODataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceName(value={"*"}, type={DraftService.class})
class DraftMessagesWriteHandler
implements EventHandler {
    public static final String DRAFT_MESSAGES_SKIP_HINT = "cds.draftMessages.skip";
    private static final Set<String> DRAFT_VALIDATION_EVENTS = Set.of("DRAFT_NEW", "DRAFT_PATCH", "DRAFT_CANCEL");
    static final String STORE_MESSAGES = "cds.internal.draftMessages.storeMessages";

    DraftMessagesWriteHandler() {
    }

    @Before(event={"CREATE", "UPSERT", "UPDATE", "DRAFT_CREATE", "DRAFT_PATCH"})
    @HandlerOrder(value=-10400)
    void clearDraftMessages(EventContext context, List<CdsData> dataList) {
        DataProcessor.create().bulkAction((type, entries) -> {
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)type)) {
                entries.forEach(e -> e.remove("DraftMessages"));
            }
        }).process(dataList, (CdsStructuredType)context.getTarget());
    }

    @Before
    @HandlerOrder(value=-10300)
    void isStorageRequired(EventContext context, CqnStatement cqn) {
        if (!DRAFT_VALIDATION_EVENTS.contains(context.getEvent()) && !DraftMessagesWriteHandler.isActionOnDraft(context, cqn) || !DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget()) || cqn.hints().containsKey(DRAFT_MESSAGES_SKIP_HINT) || !DraftMessagesWriteHandler.isById(cqn.ref(), context)) {
            return;
        }
        context.put(STORE_MESSAGES, (Object)true);
        context.put("cds.internal.validations.throwIfErrorInAfter", (Object)true);
    }

    @Before
    @HandlerOrder(value=11000)
    void initializeMessages(DraftCreateEventContext context, List<CdsData> dataList) {
        if (DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            for (CdsData data : dataList) {
                DraftAdministrativeData dad = ((Drafts)Struct.access((Map)data).as(Drafts.class)).getDraftAdministrativeData();
                if (dad == null || dad.get((Object)"DraftMessages") != null) continue;
                dad.put((Object)"DraftMessages", new ArrayList(0));
            }
        }
    }

    @Before
    @HandlerOrder(value=11200)
    void throwOnInvalidActionParameters(EventContext context) {
        if (!DraftMessageUtils.isDraftMessagesStored(context)) {
            return;
        }
        Set previousMessages = (Set)context.get("cds.internal.validations.previousMessages");
        if (context.getMessages().stream().anyMatch(m -> !previousMessages.contains(m) && m.isTransition() && m.getSeverity().equals((Object)Message.Severity.ERROR))) {
            context.getMessages().throwIfError();
        }
    }

    @After
    @HandlerOrder(value=10999)
    void persistMessages(EventContext context, CqnStructuredTypeRef ref, Result result) {
        if (!DraftMessageUtils.isDraftMessagesStored(context)) {
            return;
        }
        String event = context.getEvent();
        ArrayList<String> patchedTargets = new ArrayList<String>();
        if (result != null && result.rowCount() == 1L) {
            if ("DRAFT_PATCH".equals(event)) {
                CqnStructuredTypeRef requestRef = ref;
                CdsDataProcessor.create().addValidator((p, e, t) -> true, (p, e, v) -> patchedTargets.add(DraftMessageUtils.stringifyMessageTarget(DraftMessageUtils.prefixMessageTarget(requestRef, MessageTarget.create((Path)p, (CdsElement)e))))).process((Iterable)result, (CdsStructuredType)context.getTarget());
            }
            if ("DRAFT_NEW".equals(event) && ref.targetSegment().filter().isEmpty()) {
                RefBuilder copy = CQL.copy((CqnStructuredTypeRef)ref);
                result.single().ref().asRef().targetSegment().filter().ifPresent(f -> copy.targetSegment().filter(f));
                ref = (CqnStructuredTypeRef)copy.build();
            }
        }
        Set previousMessages = (Set)context.get("cds.internal.validations.previousMessages");
        List newMessages = context.getMessages().removeIf(m -> !previousMessages.contains(m) && !m.isTransition());
        if (!("DRAFT_CANCEL".equals(event) && ref.size() <= 1 || newMessages.isEmpty() && !this.requiresInvalidation(patchedTargets, event, ref))) {
            List<DraftMessage> draftMessages = this.loadMessages(context, ref);
            boolean invalidated = this.invalidateMessages(draftMessages, patchedTargets, ref, context);
            for (Message message : newMessages) {
                draftMessages.add(DraftMessageUtils.toDraftMessage(message, ref));
            }
            if (invalidated || !newMessages.isEmpty()) {
                CqnStructuredTypeRef updateRef = "DRAFT_CANCEL".equals(event) ? DraftMessagesWriteHandler.parentOf(ref) : ref;
                HashMap<String, Map<String, List<DraftMessage>>> data = new HashMap<String, Map<String, List<DraftMessage>>>(Map.of("DraftAdministrativeData", Map.of("DraftMessages", draftMessages)));
                data.putAll(CqnAnalyzer.create((CdsModel)context.getModel()).analyze(updateRef).targetKeyValues());
                CqnUpdate writeDraftMessages = (CqnUpdate)Update.entity((CqnStructuredTypeRef)updateRef).data(data).hint(DRAFT_MESSAGES_SKIP_HINT, (Object)true);
                ((DraftService)context.getService()).patchDraft(writeDraftMessages, new Object[0]);
            }
        }
    }

    private List<DraftMessage> loadMessages(EventContext context, CqnStructuredTypeRef ref) {
        String event = context.getEvent();
        ArrayList<DraftMessage> messages = new ArrayList<DraftMessage>();
        if (!"DRAFT_NEW".equals(event) || ref.size() > 1) {
            Collection draftMessages;
            Select queryDraftMessages = Select.from((CqnStructuredTypeRef)DraftMessagesWriteHandler.toDraftAdministrativeData("DRAFT_NEW".equals(event) || "DRAFT_CANCEL".equals(event) ? DraftMessagesWriteHandler.parentOf(ref) : ref));
            Result draftMessagesResult = DraftServiceImpl.downcast(context.getService()).readDraft((CqnSelect)queryDraftMessages, new Object[0]);
            if (draftMessagesResult.rowCount() == 1L && (draftMessages = (Collection)draftMessagesResult.single().get((Object)"DraftMessages")) != null) {
                Struct.stream((Iterable)draftMessages).as(DraftMessage.class).forEach(messages::add);
            }
        }
        return messages;
    }

    private boolean requiresInvalidation(List<String> patchedTargets, String event, CqnStructuredTypeRef ref) {
        return "DRAFT_PATCH".equals(event) && !patchedTargets.isEmpty() || "DRAFT_CANCEL".equals(event) && ref.size() > 1;
    }

    private boolean invalidateMessages(List<DraftMessage> draftMessages, List<String> patchedTargets, CqnStructuredTypeRef ref, EventContext context) {
        String event = context.getEvent();
        if ("DRAFT_PATCH".equals(event) && !patchedTargets.isEmpty()) {
            return draftMessages.removeIf(draftMessage -> patchedTargets.stream().anyMatch(patchedTarget -> patchedTarget.equals(draftMessage.getTarget()) || draftMessage.getAdditionalTargets() != null && draftMessage.getAdditionalTargets().stream().anyMatch(t -> patchedTarget.equals(t))));
        }
        if ("DRAFT_CANCEL".equals(event) && ref.size() > 1) {
            CqnStructuredTypeRef refForTarget = DraftMessageUtils.forTarget(ref);
            String deletedTarget = ODataUtils.toODataTarget(null, null, (CqnReference)refForTarget, (boolean)false);
            return draftMessages.removeIf(m -> this.matchesDeletedTarget(deletedTarget, m.getTarget()) || m.getAdditionalTargets() != null && m.getAdditionalTargets().stream().anyMatch(t -> this.matchesDeletedTarget(deletedTarget, (String)t)));
        }
        return false;
    }

    private boolean matchesDeletedTarget(String deletedTarget, String stringifiedTarget) {
        MessageTarget target = DraftMessageUtils.parseMessageTarget(stringifiedTarget);
        if (target != null) {
            String odataTarget = ODataUtils.toODataTarget(null, (String)target.getParameter(), (CqnReference)target.getRef(), (boolean)false);
            return deletedTarget.equals(odataTarget) || odataTarget.startsWith(deletedTarget + "/");
        }
        return false;
    }

    private static boolean isActionOnDraft(EventContext context, CqnStatement cqn) {
        if (context.getTarget() != null && !"draftActivate".equals(context.getEvent()) && context.getTarget().findAction(context.getEvent()).isPresent()) {
            Object isActiveEntity = CqnAnalyzer.create((CdsModel)context.getModel()).analyze(cqn.ref()).targetKeyValues().get("IsActiveEntity");
            return Boolean.FALSE.equals(isActiveEntity);
        }
        return false;
    }

    private static boolean isById(CqnStructuredTypeRef ref, EventContext context) {
        return ref.targetSegment().filter().isPresent() || "DRAFT_NEW".equals(context.getEvent());
    }

    private static CqnStructuredTypeRef parentOf(CqnStructuredTypeRef ref) {
        return CQL.to(ref.segments().subList(0, ref.size() - 1)).asRef();
    }

    private static CqnStructuredTypeRef toDraftAdministrativeData(CqnStructuredTypeRef ref) {
        ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(ref.segments());
        segments.add(CQL.refSegment((String)"DraftAdministrativeData"));
        return CQL.to(segments).asRef();
    }
}

