/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.application;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;

@ServiceName(value={"*"}, type={ApplicationLifecycleService.class})
public class ErrorResponseHandler
implements EventHandler {
    @On
    @HandlerOrder(value=11000)
    public void onErrorResponse(ErrorResponseEventContext context) {
        ServiceException exception = context.getException();
        ErrorResponseEventContext.ErrorResponse response = ErrorResponseEventContext.ErrorResponse.create();
        response.setHttpStatus(Integer.valueOf(exception.getErrorStatus().getHttpStatus()));
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(this.toMessage(exception, (EventContext)context));
        context.getMessages().stream().forEach(messages::add);
        response.setMessages(messages);
        context.setResult(response);
    }

    private Message toMessage(ServiceException exception, EventContext context) {
        String localizedMessage = exception.getLocalizedMessage();
        String text = localizedMessage == null ? this.getDefaultDescription() : localizedMessage;
        Message message = Message.create((String)text, (ServiceException)exception);
        ErrorStatus errorStatus = exception.getErrorStatus();
        boolean stackMessagesEnabled = context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().getStackMessages().isEnabled();
        if (errorStatus instanceof CdsErrorStatuses && !stackMessagesEnabled) {
            message.code(String.valueOf(errorStatus.getHttpStatus()));
        }
        return message;
    }

    private String getDefaultDescription() {
        return new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage();
    }
}

