/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsData;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class HierarchyHandler
implements EventHandler {
    private static final String HIERARCHY_TREE_SIZE = "hierarchy_tree_size";
    private static final String HIERARCHY_LEVEL = "hierarchy_level";
    private static final String LEAF = "leaf";
    private static final String COLLAPSED = "collapsed";
    private static final String EXPANDED = "expanded";

    @Before
    public void prepare(CdsReadEventContext event) {
        CqnSelect select = event.getCqn();
        boolean isHierarchy = HierarchyHandler.isHierarchy(select);
        if (isHierarchy && !CqnAnalyzer.isCountQuery((CqnStatement)select)) {
            Map<Property, String> alias = HierarchyHandler.calculateElementNames(event.getCqn(), event.getTarget());
            boolean hasLimitedDescendantsCount = select.items().stream().flatMap(i -> i.ofValue()).anyMatch(v -> alias.getOrDefault((Object)Property.LimitedDescendantCount, "").equals(v.displayName()));
            ((Select)select).columns(List.of());
            event.put("isHierarchy", (Object)isHierarchy);
            event.put("hasLimitedDescendantsCount", (Object)hasLimitedDescendantsCount);
            event.put("alias", alias);
            event.setCqn(select);
        }
    }

    @After
    public void enrichResult(CdsReadEventContext event, List<CdsData> rows) {
        if (Boolean.TRUE.equals(event.get("isHierarchy"))) {
            boolean hasLimitedDescendantsCount = Boolean.TRUE.equals(event.get("hasLimitedDescendantsCount"));
            Map alias = (Map)event.get("alias");
            HierarchyHandler.addDrillStateAndDistanceFromRoot(rows, hasLimitedDescendantsCount, alias);
        }
    }

    private static void addDrillStateAndDistanceFromRoot(List<CdsData> rows, boolean calcLimitedDescendantsCount, Map<Property, String> alias) {
        if (rows.isEmpty() || !rows.get(0).containsKey((Object)HIERARCHY_LEVEL)) {
            return;
        }
        HashMap<Object, CdsData> rowByNodeId = new HashMap<Object, CdsData>();
        Set parents = rows.stream().peek(r -> rowByNodeId.put(HierarchyHandler.getRowValue(r, Property.NodeProperty, alias), (CdsData)r)).map(r -> HierarchyHandler.getRowValue(r, Property.ParentProperty, alias)).filter(p -> p != null).collect(Collectors.toSet());
        for (CdsData row : rows) {
            Object nodeId = HierarchyHandler.getRowValue(row, Property.NodeProperty, alias);
            HierarchyHandler.putRowValue(row, Property.DistanceFromRoot, ((Number)row.remove((Object)HIERARCHY_LEVEL)).longValue() - 1L, alias);
            long treeSize = (Long)row.remove((Object)HIERARCHY_TREE_SIZE);
            if (treeSize > 1L) {
                if (parents.contains(nodeId)) {
                    HierarchyHandler.putRowValue(row, Property.DrillState, EXPANDED, alias);
                } else {
                    HierarchyHandler.putRowValue(row, Property.DrillState, COLLAPSED, alias);
                }
            } else {
                HierarchyHandler.putRowValue(row, Property.DrillState, LEAF, alias);
            }
            if (!calcLimitedDescendantsCount) continue;
            HierarchyHandler.incrementLimitedDescendant(rowByNodeId, nodeId, alias);
        }
    }

    private static void incrementLimitedDescendant(Map<Object, CdsData> rowByNodeId, Object nodeId, Map<Property, String> alias) {
        CdsData row = rowByNodeId.get(nodeId);
        if (row != null) {
            Object ldc = HierarchyHandler.getRowValue(row, Property.LimitedDescendantCount, alias);
            long count = ldc == null ? -1L : (Long)ldc;
            HierarchyHandler.putRowValue(row, Property.LimitedDescendantCount, ++count, alias);
            HierarchyHandler.incrementLimitedDescendant(rowByNodeId, HierarchyHandler.getRowValue(row, Property.ParentProperty, alias), alias);
        }
    }

    private static boolean isHierarchyTransformation(CqnTransformation t) {
        return t.kind() == CqnTransformation.Kind.ANCESTORS || t.kind() == CqnTransformation.Kind.DESCENDANTS || t.kind() == CqnTransformation.Kind.TOPLEVELS;
    }

    private static boolean isHierarchy(CqnSelect select) {
        return select.transformations().stream().anyMatch(HierarchyHandler::isHierarchyTransformation);
    }

    private static Map<Property, String> calculateElementNames(CqnSelect cqn, CdsEntity target) {
        HashMap<Property, String> alias = new HashMap<Property, String>(8);
        cqn.transformations().stream().filter(HierarchyHandler::isHierarchyTransformation).findFirst().ifPresent(t -> {
            String qualifier = HierarchyHandler.qualifier(t);
            target.concreteNonAssociationElements().forEach(e -> {
                String name = e.getName();
                if ("NODE_ID".equals(name.toUpperCase())) {
                    alias.put(Property.NodeProperty, name);
                }
                if ("PARENT_ID".equals(name.toUpperCase())) {
                    alias.put(Property.ParentProperty, name);
                }
            });
            String recursiveHierarchyAnno = "Hierarchy.RecursiveHierarchy#" + qualifier;
            alias.put(Property.LimitedDescendantCount, HierarchyHandler.getAnnotationValue(target, recursiveHierarchyAnno + ".LimitedDescendantCount"));
            alias.put(Property.DrillState, HierarchyHandler.getAnnotationValue(target, recursiveHierarchyAnno + ".DrillState"));
            alias.put(Property.DistanceFromRoot, HierarchyHandler.getAnnotationValue(target, recursiveHierarchyAnno + ".DistanceFromRoot"));
        });
        return alias;
    }

    private static String qualifier(CqnTransformation t) {
        return switch (t.kind()) {
            case CqnTransformation.Kind.ANCESTORS, CqnTransformation.Kind.DESCENDANTS -> ((CqnHierarchySubsetTransformation)t).hierarchyQualifier();
            case CqnTransformation.Kind.TOPLEVELS -> ((CqnTopLevelsTransformation)t).hierarchyQualifier();
            default -> null;
        };
    }

    private static String getAnnotationValue(CdsEntity entity, String anno) {
        Map annotationValue = (Map)entity.getAnnotationValue(anno, Collections.emptyMap());
        return (String)annotationValue.get("=");
    }

    private static Object getRowValue(CdsData row, Property element, Map<Property, String> alias) {
        return row.get((Object)alias.get((Object)element));
    }

    private static void putRowValue(CdsData row, Property element, Object value, Map<Property, String> alias) {
        row.put((Object)alias.get((Object)element), value);
    }

    private static enum Property {
        NodeProperty,
        ParentProperty,
        LimitedDescendantCount,
        DrillState,
        DistanceFromRoot;

    }
}

