/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.local;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.messaging.MessagingErrorEventContext;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.messaging.service.AbstractMessagingService;
import com.sap.cds.services.messaging.service.MessagingBrokerQueueListener;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMessagingService
extends AbstractMessagingService {
    public static final String LOCAL_KIND = "local-messaging";
    private static final Logger logger = LoggerFactory.getLogger(LocalMessagingService.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public LocalMessagingService(CdsProperties.Messaging.MessagingServiceConfig serviceConfig, CdsRuntime runtime) {
        super(serviceConfig, runtime);
    }

    public void init() {
    }

    protected void removeQueue(String name) {
    }

    protected void createQueue(String name, Map<String, Object> properties) {
    }

    protected void createQueueSubscription(String queue, String topic) {
    }

    protected void registerQueueListener(String queue, MessagingBrokerQueueListener listener) {
    }

    protected String toFullyQualifiedTopicName(String event, boolean inbound) {
        return event;
    }

    protected void emitTopicMessage(String topic, TopicMessageEventContext messageEventContext) {
        if (this.queue.hasEvent(topic)) {
            try {
                this.executor.submit(() -> this.runtime.requestContext().privilegedUser().run(context -> {
                    try {
                        TopicMessageEventContext incoming = TopicMessageEventContext.create((String)topic);
                        incoming.setIsInbound(true);
                        incoming.setData(messageEventContext.getData());
                        incoming.setHeadersMap(messageEventContext.getHeadersMap());
                        incoming.setDataMap(messageEventContext.getDataMap());
                        incoming.setMessageId(UUID.randomUUID().toString());
                        this.emit((EventContext)incoming);
                    }
                    catch (Throwable th) {
                        ServiceException se;
                        MessagingErrorEventContext errorContext = MessagingErrorEventContext.create();
                        ServiceException e = th instanceof ServiceException ? (se = (ServiceException)th) : new ServiceException(th);
                        errorContext.setException(e);
                        this.emit((EventContext)errorContext);
                        throw th;
                    }
                })).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new ServiceException(e.getCause());
            }
        } else {
            logger.debug("Topic '{}' does not have any subscriptions. Message '{}' is discarded.", (Object)topic, (Object)messageEventContext.getData());
        }
    }
}

