/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.model;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.RequestContextSuppressor;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelProvider
implements CdsModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(DynamicModelProvider.class);
    public static final FeatureTogglesInfo STATIC_MODEL_ACCESS_FEATURE = FeatureTogglesInfo.all();
    private final CdsRuntime runtime;
    private final DynamicModelUtils utils;
    private final MetaDataAccessor<String> accessor;

    public DynamicModelProvider(final CdsRuntime runtime) {
        this.runtime = runtime;
        this.utils = new DynamicModelUtils(runtime);
        this.accessor = this.utils.createMetadataAccessor(null, new MetaDataAccessorImpl.CdsModelCreator(){

            public CdsModel parse(String csn) {
                return CdsModelReader.read((CdsModelReader.Config)CdsModelUtils.buildCdsModelReaderConfig(runtime), (String)csn, (boolean)true);
            }

            public CdsModel getBaseModel() {
                return runtime.getCdsModel();
            }
        }, null);
    }

    public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        if (featureTogglesInfo == STATIC_MODEL_ACCESS_FEATURE || this.utils.useStaticModel(userInfo, featureTogglesInfo)) {
            return this.runtime.getCdsModel();
        }
        ModelId modelId = this.utils.prepareModelId(userInfo, featureTogglesInfo).build();
        if (logger.isDebugEnabled()) {
            String featureToggles = modelId.getFeatures().stream().collect(Collectors.joining(","));
            logger.debug("Fetching the model for tenant '{}' and feature toggles '{}'", (Object)modelId.getTenantId(), (Object)featureToggles);
        }
        try (RequestContextSuppressor suppressor = new RequestContextSuppressor();){
            CdsModel cdsModel = this.accessor.getCdsModel(modelId, Integer.MAX_VALUE);
            return cdsModel;
        }
    }
}

