/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox.persistence.collectors;

import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCache {
    private static final Logger LOG = LoggerFactory.getLogger(TenantCache.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private TenantProviderService tenantService;
    private volatile List<String> tenantsInfo = new ArrayList<String>();

    public List<String> getTenants() {
        return this.tenantsInfo;
    }

    public void start(CdsRuntime runtime) {
        if (this.tenantService == null) {
            this.tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
            long tenantsInfoRefreshIntervalSeconds = runtime.getEnvironment().getCdsProperties().getOutbox().getTenantsInfoRefreshInterval().getSeconds();
            this.scheduler.scheduleAtFixedRate(this::updateTenants, 0L, tenantsInfoRefreshIntervalSeconds, TimeUnit.SECONDS);
            this.updateTenants();
        }
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }

    private void updateTenants() {
        try {
            LOG.debug("Updating cached tenants for partition collectors");
            this.tenantsInfo = Collections.unmodifiableList(this.tenantService.readTenants());
        }
        catch (Exception e) {
            LOG.warn("Failed to update cached tenants for partition collectors", (Throwable)e);
        }
    }
}

