/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.google.common.reflect.TypeToken;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.Service;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.impl.ServiceCatalogImpl;
import com.sap.cds.services.impl.ServiceCatalogSPI;
import com.sap.cds.services.impl.ServiceExceptionUtilsImpl;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.environment.DefaultApplicationInfoProvider;
import com.sap.cds.services.impl.environment.DefaultServiceBindingProvider;
import com.sap.cds.services.impl.environment.SimplePropertiesProvider;
import com.sap.cds.services.impl.handlerregistry.HandlerRegistryTools;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.runtime.ChangeSetContextRunnerImpl;
import com.sap.cds.services.impl.runtime.RequestContextRunnerImpl;
import com.sap.cds.services.impl.runtime.mockusers.MockedFeatureTogglesProvider;
import com.sap.cds.services.impl.runtime.mockusers.MockedUserInfoProvider;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import com.sap.cds.services.runtime.FeatureTogglesInfoProvider;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.runtime.UserInfoProvider;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsRuntimeImpl
implements CdsRuntime {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeImpl.class);
    private static final String BASE_PACKAGE = "com.sap.cds.";
    private final CdsEnvironment environment;
    private final ServiceCatalogImpl serviceCatalog = new ServiceCatalogImpl();
    private final Map<Class<? extends CdsProvider<?>>, CdsProvider<?>> providers = new HashMap();
    private CdsModel cdsModel = CdsModelUtils.loadCdsModel(null);

    CdsRuntimeImpl(PropertiesProvider propertiesProvider) {
        this.environment = new CdsEnvironmentImpl(propertiesProvider);
        this.providers.put((Class<CdsProvider<?>>)ServiceBindingProvider.class, (CdsProvider<?>)new DefaultServiceBindingProvider(this));
        this.providers.put((Class<CdsProvider<?>>)ApplicationInfoProvider.class, (CdsProvider<?>)new DefaultApplicationInfoProvider(this));
        this.providers.put((Class<CdsProvider<?>>)CdsModelProvider.class, (CdsProvider<?>)new DefaultModelProvider());
        this.providers.put((Class<CdsProvider<?>>)UserInfoProvider.class, (CdsProvider<?>)new MockedUserInfoProvider(this));
        this.providers.put((Class<CdsProvider<?>>)AuthenticationInfoProvider.class, (CdsProvider<?>)((AuthenticationInfoProvider)() -> null));
        this.providers.put((Class<CdsProvider<?>>)ParameterInfoProvider.class, (CdsProvider<?>)((ParameterInfoProvider)() -> null));
        this.providers.put((Class<CdsProvider<?>>)LocalizedMessageProvider.class, (CdsProvider<?>)new SimpleLocalizedMessageProvider());
        this.providers.put((Class<CdsProvider<?>>)FeatureTogglesInfoProvider.class, (CdsProvider<?>)new MockedFeatureTogglesProvider(this));
    }

    public ServiceCatalogSPI getServiceCatalog() {
        return this.serviceCatalog;
    }

    public CdsModel getCdsModel() {
        return this.cdsModel;
    }

    public CdsModel getCdsModel(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        return this.getProvider(CdsModelProvider.class).get(userInfo, featureTogglesInfo);
    }

    public CdsEnvironment getEnvironment() {
        return this.environment;
    }

    public ParameterInfo getProvidedParameterInfo() {
        ParameterInfo parameterInfo = this.getProvider(ParameterInfoProvider.class).get();
        return parameterInfo != null ? parameterInfo : ParameterInfo.create();
    }

    public UserInfo getProvidedUserInfo() {
        UserInfo userInfo = this.getProvider(UserInfoProvider.class).get();
        return userInfo != null ? userInfo : UserInfo.create();
    }

    public AuthenticationInfo getProvidedAuthenticationInfo() {
        return this.getProvider(AuthenticationInfoProvider.class).get();
    }

    public FeatureTogglesInfo getFeatureTogglesInfo(UserInfo userInfo, ParameterInfo parameterInfo) {
        FeatureTogglesInfo featureTogglesInfo = this.getProvider(FeatureTogglesInfoProvider.class).get(userInfo, parameterInfo);
        return featureTogglesInfo != null ? featureTogglesInfo : (userInfo.isSystemUser() ? FeatureTogglesInfo.all() : FeatureTogglesInfo.create((FeatureToggle[])new FeatureToggle[0]));
    }

    public String getLocalizedMessage(String code, Object[] args, Locale locale) {
        return this.getProvider(LocalizedMessageProvider.class).get(code, args, locale);
    }

    public <T extends CdsProvider<T>> T getProvider(Class<T> clazz) {
        return (T)this.providers.get(clazz);
    }

    public RequestContextRunner requestContext() {
        return new RequestContextRunnerImpl(this);
    }

    public ChangeSetContextRunner changeSetContext() {
        return new ChangeSetContextRunnerImpl(this);
    }

    void setCdsModel(String csnPath) {
        this.cdsModel = CdsModelUtils.loadCdsModel(CdsModelUtils.buildCdsModelReaderConfig(this), csnPath);
    }

    void setCdsModel(CdsModel model) {
        this.cdsModel = model;
    }

    void registerService(Service service) {
        this.serviceCatalog.register(service);
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(service);
        if (serviceSPI != null) {
            serviceSPI.setCdsRuntime(this);
        }
    }

    <T> void registerEventHandler(Class<T> handlerClass, Supplier<T> handlerFactory) {
        HandlerRegistryTools.registerClass(handlerClass, handlerFactory, this.serviceCatalog);
        if (handlerClass.getPackage().getName().startsWith(BASE_PACKAGE)) {
            logger.debug("Registered handler class {}", (Object)handlerClass.getName());
        } else {
            logger.info("Registered handler class {}", (Object)handlerClass.getName());
        }
    }

    <T extends CdsProvider<T>> void registerProvider(CdsProvider<T> provider) {
        Class<T> clazz = CdsRuntimeImpl.determineProviderClass(provider);
        T current = this.getProvider(clazz);
        provider.setPrevious(current);
        this.providers.put(clazz, provider);
        if (provider instanceof LocalizedMessageProvider) {
            LocalizedMessageProvider messageProvider;
            ServiceExceptionUtilsImpl.defaultLocalizedMessageProvider = messageProvider = (LocalizedMessageProvider)provider;
        }
    }

    Map<Class<? extends CdsProvider<?>>, CdsProvider<?>> getProviders() {
        return this.providers;
    }

    private static <T extends CdsProvider<T>> Class<T> determineProviderClass(CdsProvider<T> p) {
        TypeToken token = TypeToken.of(p.getClass()).getSupertype(CdsProvider.class);
        TypeToken resolved = token.resolveType(CdsProvider.class.getTypeParameters()[0]);
        return resolved.getRawType();
    }

    private class CdsEnvironmentImpl
    implements CdsEnvironment {
        private final CdsProperties properties;
        private final PropertiesProvider propertiesProvider;

        public CdsEnvironmentImpl(PropertiesProvider propertiesProvider) {
            this.propertiesProvider = propertiesProvider == null ? new SimplePropertiesProvider() : propertiesProvider;
            this.properties = (CdsProperties)this.propertiesProvider.bindPropertyClass("cds", CdsProperties.class);
            ServiceExceptionUtilsImpl.errorsProperties = this.properties.getErrors();
        }

        public CdsProperties getCdsProperties() {
            return this.properties;
        }

        public <T> T getProperty(String key, Class<T> asClazz, T defaultValue) {
            return (T)this.propertiesProvider.getProperty(key, asClazz, defaultValue);
        }

        public Stream<ServiceBinding> getServiceBindings() {
            return CdsRuntimeImpl.this.getProvider(ServiceBindingProvider.class).get();
        }

        public ApplicationInfo getApplicationInfo() {
            return CdsRuntimeImpl.this.getProvider(ApplicationInfoProvider.class).get();
        }
    }

    private class DefaultModelProvider
    implements CdsModelProvider {
        private DefaultModelProvider() {
        }

        public CdsModel get(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
            return CdsRuntimeImpl.this.cdsModel;
        }
    }
}

