/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PersonalDataUtils {
    static final String PERSONAL_DATA_PREFIX = "@audit:";
    private final CdsStructuredType entity;
    private final PersonalDataCaches caches;
    private Boolean personalDataDeleted;
    private Set<CqnSelectListValue> resolveDataSubjectId;
    private Function<?, CqnSelectListItem>[] expandCompositionsForDelete;

    PersonalDataUtils(CdsStructuredType entity, PersonalDataCaches caches) {
        this.entity = Objects.requireNonNull(entity, "entity must not be null");
        this.caches = Objects.requireNonNull(caches, "caches must not be null");
    }

    boolean hasPersonalDataDeleted() {
        if (this.personalDataDeleted == null) {
            this.personalDataDeleted = this.hasPersonalDataDeleted(this.entity);
        }
        return this.personalDataDeleted;
    }

    Set<CqnSelectListValue> resolveDataSubjectId() {
        if (this.resolveDataSubjectId == null) {
            this.resolveDataSubjectId = Collections.unmodifiableSet(this.resolveDataSubjectId(this.entity, null));
        }
        return this.resolveDataSubjectId;
    }

    <T> Function<T, CqnSelectListItem>[] expandCompositionsForDelete() {
        if (this.expandCompositionsForDelete == null) {
            this.expandCompositionsForDelete = this.expandCompositionsForDelete(this.entity, new HashSet<String>());
        }
        return Arrays.copyOf(this.expandCompositionsForDelete, this.expandCompositionsForDelete.length);
    }

    private Set<CqnSelectListValue> resolveDataSubjectId(CdsStructuredType entity, StructuredType<?> path) {
        HashSet<CqnSelectListValue> result = new HashSet<CqnSelectListValue>();
        HashMap associations = new HashMap();
        PersonalDataMeta pdMeta = this.getMeta(entity);
        pdMeta.getDataSubjectIds().stream().filter(element -> element.getType().isAssociation()).forEach(element -> associations.put(element, null));
        pdMeta.getDataSubjectIds().stream().filter(element -> element.getType().isSimple()).forEach(element -> {
            String assoc = (String)CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrValue((CdsAnnotatable)element, null);
            if (assoc != null) {
                CdsElement assocElement = entity.getAssociation(assoc);
                if (associations.get(assocElement) != null) {
                    ((List)associations.get(assocElement)).add(element);
                } else {
                    LinkedList<CdsElement> foreignKeys = new LinkedList<CdsElement>();
                    foreignKeys.add((CdsElement)element);
                    associations.put(assocElement, foreignKeys);
                }
            } else {
                result.add(this.appendElement(path, element.getName(), element.getName()));
            }
        });
        associations.entrySet().stream().forEach(entry -> {
            CdsElement assoc = (CdsElement)entry.getKey();
            if (this.foreignKeysAreDataSubjectIds(entity, assoc, (List)entry.getValue())) {
                ((List)entry.getValue()).forEach(element -> result.add(this.appendElement(path, element.getName(), this.extractKeyName((CdsElement)element, assoc))));
            } else {
                String assocName = assoc.getName();
                StructuredType newPath = path != null ? path.to(assocName) : CQL.to((String)assocName);
                result.addAll(this.resolveDataSubjectId(entity.getTargetOf(assocName), newPath));
            }
        });
        return result;
    }

    private String extractKeyName(CdsElement element, CdsElement assoc) {
        String name = element.getName();
        return name.replace(assoc.getName() + "_", "");
    }

    private CqnSelectListValue appendElement(StructuredType<?> path, String element, String idName) {
        ElementRef ref = path != null ? path.get(element) : CQL.get((String)element);
        return ref.as(PersonalDataUtils.getDSIdAlias(idName));
    }

    private boolean foreignKeysAreDataSubjectIds(CdsStructuredType entity, CdsElement assoc, List<CdsElement> foreignKeys) {
        CdsEntity target = (CdsEntity)entity.getTargetOf(assoc.getName());
        PersonalDataMeta pdMeta = this.getMeta((CdsStructuredType)target);
        if (!pdMeta.isDataSubject()) {
            return false;
        }
        if (foreignKeys == null || pdMeta.getDataSubjectIds().size() != foreignKeys.size()) {
            return false;
        }
        Set fkNames = foreignKeys.stream().map(CdsElementDefinition::getName).collect(Collectors.toSet());
        return pdMeta.getDataSubjectIds().stream().allMatch(key -> fkNames.contains(assoc.getName() + "_" + key.getName()));
    }

    private boolean hasPersonalDataDeleted(CdsStructuredType entity) {
        boolean hasPDdeleted = this.getMeta(entity).hasPersonalData();
        if (!hasPDdeleted) {
            hasPDdeleted = this.getAssociationsWithPersonalData(entity).map(element -> (CdsAssociationType)element.getType().as(CdsAssociationType.class)).anyMatch(assoc -> this.hasPersonalDataDeleted((CdsStructuredType)assoc.getTarget()));
        }
        return hasPDdeleted;
    }

    private <T> Function<T, CqnSelectListItem>[] expandCompositionsForDelete(CdsStructuredType entity, Set<String> expanded) {
        if (expanded.contains(entity.getQualifiedName())) {
            return Collections.emptyList().toArray(new Function[0]);
        }
        expanded.add(entity.getQualifiedName());
        ArrayList<Function<StructuredType, CqnSelectListItem>> columns = new ArrayList<Function<StructuredType, CqnSelectListItem>>();
        columns.add(StructuredType::_all);
        this.getAssociationsWithPersonalData(entity).forEach(element -> {
            CdsEntity targetOf = (CdsEntity)entity.getTargetOf(element.getName());
            columns.add(c -> c.to(element.getName()).expand((Function[])this.expandCompositionsForDelete((CdsStructuredType)targetOf, expanded)));
        });
        return columns.toArray(new Function[columns.size()]);
    }

    private Stream<CdsElement> getAssociationsWithPersonalData(CdsStructuredType entity) {
        return entity.associations().filter(element -> {
            CdsAssociationType assocType = (CdsAssociationType)element.getType().as(CdsAssociationType.class);
            return (Boolean)CdsAnnotations.CASCADE_DELETE.getOrValue((CdsAnnotatable)element, (Object)assocType.isComposition()) != false && this.getMeta((CdsStructuredType)assocType.getTarget()).hasPersonalData();
        });
    }

    private PersonalDataMeta getMeta(CdsStructuredType entity) {
        return this.caches.getMeta(entity);
    }

    static String getDSIdAlias(String id) {
        return "@audit:DS_" + id;
    }

    static String getKeyAlias(String key) {
        return PERSONAL_DATA_PREFIX + key;
    }
}

