/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ReadOnlyHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=-10500)
    public void cleanReadOnlyFields(EventContext context) {
        String event = context.getEvent();
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        DataProcessor.create().bulkAction((struct, data) -> {
            for (Map map : data) {
                Set readOnlyElementNames = struct.elements().filter(element -> this.isReadOnly((CdsElement)element, event, map)).map(e -> e.getName()).collect(Collectors.toSet());
                if (readOnlyElementNames.isEmpty()) {
                    return;
                }
                for (String e2 : readOnlyElementNames) {
                    map.remove(e2);
                }
            }
        }).process(entries, (CdsStructuredType)context.getTarget());
    }

    public boolean isReadOnly(CdsElement element, String event, Map<String, Object> map) {
        boolean onInsert;
        if (element == null) {
            return false;
        }
        boolean onUpdate = CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)element) != null;
        boolean bl = onInsert = CdsAnnotations.ON_INSERT.getOrDefault((CdsAnnotatable)element) != null;
        if (onUpdate || onInsert && !"UPSERT".equals(event)) {
            return true;
        }
        boolean readOnly = CdsAnnotations.READONLY.isTrue((CdsAnnotatable)element);
        boolean fieldControlReadOnly = CdsAnnotations.FIELD_CONTROL_READONLY.isTrue((CdsAnnotatable)element);
        Map commonFieldControl = (Map)CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault((CdsAnnotatable)element);
        if (readOnly || fieldControlReadOnly || commonFieldControl != null && "ReadOnly".equals(commonFieldControl.get("#"))) {
            return true;
        }
        boolean coreComputed = CdsAnnotations.CORE_COMPUTED.isTrue((CdsAnnotatable)element);
        if (coreComputed && !onUpdate && !onInsert && !element.isKey()) {
            return true;
        }
        boolean coreImmutable = CdsAnnotations.CORE_IMMUTABLE.isTrue((CdsAnnotatable)element);
        return coreImmutable && "UPDATE".equals(event) && (!map.containsKey("HasActiveEntity") || !Boolean.FALSE.equals(map.get("HasActiveEntity")));
    }
}

