/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.authorization.ActionAccessEventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.GetRestrictionEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.PredicateLookup;
import com.sap.cds.services.impl.authorization.PredicateResolver;
import com.sap.cds.services.impl.authorization.RestrictionLookup;
import com.sap.cds.services.impl.authorization.RestrictionUtils;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.Privilege;
import com.sap.cds.services.utils.model.Restriction;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={AuthorizationService.class})
public class AuthorizationDefaultOnHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationDefaultOnHandler.class);
    private final TenantAwareCache<RestrictionLookup, CdsModel> restrictionLookupCache;
    private final TenantAwareCache<PredicateLookup, CdsModel> predicateLookupCache;
    private final boolean isEmptyAttributeValuesAreRestricted;

    AuthorizationDefaultOnHandler(CdsRuntime runtime) {
        this.restrictionLookupCache = TenantAwareCache.create(RestrictionLookup::new, (CdsRuntime)runtime);
        this.predicateLookupCache = TenantAwareCache.create(PredicateLookup::new, (CdsRuntime)runtime);
        this.isEmptyAttributeValuesAreRestricted = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthorization().isEmptyAttributeValuesAreRestricted();
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultGetRestriction(GetRestrictionEventContext context) {
        Restriction restriction = switch (context.getKind()) {
            case CdsKind.SERVICE -> ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveServiceRestriction(context.getModel(), context.getName());
            case CdsKind.ENTITY -> ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).retrieveEntityRestriction(context.getModel(), context.getName());
            case CdsKind.ACTION -> ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupActionRestriction(context.getModel(), context.getName(), context.getEventName());
            case CdsKind.FUNCTION -> ((RestrictionLookup)this.restrictionLookupCache.findOrCreate()).lookupFunctionRestriction(context.getModel(), context.getName(), context.getEventName());
            default -> throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_RESTRICTION, new Object[]{context.getName(), context.getKind()});
        };
        context.setResult((Object)restriction);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasServiceAccess(ServiceAccessEventContext context) {
        String event = context.getAccessEventName();
        String service = context.getAccessServiceName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getServiceRestriction(context.getService(), service, event);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event);
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasEntityAccess(EntityAccessEventContext context) {
        boolean result = true;
        String event = context.getAccessEventName();
        String authorizationEntityName = context.getAccessEntityName();
        Restriction restriction = RestrictionUtils.getEntityRestriction(context.getService(), authorizationEntityName, event);
        if (restriction != null && !RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), event)) {
            logger.debug("No authorization to send event '{}' to entity '{}'", (Object)event, (Object)authorizationEntityName);
            result = false;
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasFunctionAccess(FunctionAccessEventContext context) {
        String functionName = context.getFunctionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getFunctionRestriction(context.getService(), entityName, functionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultHasActionAccess(ActionAccessEventContext context) {
        String actionName = context.getActionName();
        String entityName = context.getEntityName();
        boolean result = true;
        Restriction restriction = RestrictionUtils.getActionRestriction(context.getService(), entityName, actionName);
        if (restriction != null) {
            result = RestrictionUtils.passesRestriction(restriction, context.getUserInfo(), Privilege.PredefinedGrant.ALL.toString());
        }
        context.setResult(result);
    }

    @On
    @HandlerOrder(value=11000)
    protected void defaultCalcWhereCondition(CalcWhereConditionEventContext context) {
        String event = context.getEventName();
        String entityName = context.getEntityName();
        Predicate result = null;
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>(2);
        boolean isStandardCdsEvent = CdsModelUtils.isStandardCdsEvent(event);
        Restriction modelRestriction = RestrictionUtils.getEntityRestriction(context.getService(), entityName, event);
        if (modelRestriction != null) {
            restrictions.add(modelRestriction);
        }
        if (!isStandardCdsEvent) {
            if (CdsModelUtils.getAction(context.getCdsRuntime().getCdsModel(), entityName, event).isPresent()) {
                modelRestriction = RestrictionUtils.getActionRestriction(context.getService(), entityName, event);
                if (modelRestriction != null) {
                    restrictions.add(modelRestriction);
                }
            } else if (CdsModelUtils.getFunction(context.getCdsRuntime().getCdsModel(), entityName, event).isPresent() && (modelRestriction = RestrictionUtils.getFunctionRestriction(context.getService(), entityName, event)) != null) {
                restrictions.add(modelRestriction);
            }
        }
        for (Restriction restriction : restrictions) {
            Predicate restrictionResult = null;
            List<Privilege> privileges = RestrictionUtils.passingPrivilegesOfRestriction(restriction, context.getUserInfo(), event).toList();
            for (Privilege privilege : privileges) {
                CqnPredicate cqnPredicate = null;
                if (privilege.hasWhere()) {
                    try {
                        logger.debug("Resolving 'where' condition '{}'", (Object)privilege.getCxnWhereCondition());
                        cqnPredicate = ((PredicateLookup)this.predicateLookupCache.findOrCreate()).resolvePredicate(privilege, context.getUserInfo(), this.isEmptyAttributeValuesAreRestricted);
                    }
                    catch (PredicateResolver.MultipleAttributeValuesNotSupportedException e) {
                        logger.debug("No authorization to send event '{}' to entity '{}' because user {} has multiple values for attribute '{}' (filter resource '{}')", new Object[]{event, entityName, context.getUserInfo().getName(), e.getAttributeName(), e.getResourceName(), e});
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN_UNSUPPORTED_USER_ATTRIBUTES, new Object[]{event, entityName, e.getAttributeName(), e});
                    }
                    catch (Exception e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_WHERE_CONDITION, new Object[]{privilege.getCxnWhereCondition(), entityName, event, context.getUserInfo().getName(), e});
                    }
                } else if (!StringUtils.isEmpty((String)privilege.getWhereCQL())) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INCONSISTENT_WHERE_CONDITION, new Object[]{privilege.getWhereCQL(), entityName});
                }
                if (cqnPredicate == null) {
                    restrictionResult = null;
                    break;
                }
                if (restrictionResult != null) {
                    restrictionResult = CQL.or((CqnPredicate)restrictionResult, cqnPredicate);
                    continue;
                }
                restrictionResult = cqnPredicate;
            }
            if (result != null) {
                result = restrictionResult != null ? CQL.and(result, restrictionResult) : result;
                continue;
            }
            result = restrictionResult;
        }
        context.setResult(result);
    }
}

