/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.handlerregistry.AnnotationDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.EventContextArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.PojoArgumentResolver;
import com.sap.cds.services.impl.handlerregistry.resolver.ReturnResolver;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class HandlerDescriptor {
    private final String methodName;
    private final MethodHandle methodHandle;
    private final List<ArgumentResolver> argumentResolvers;
    private ReturnResolver returnResolver;
    private String[] defaultServiceNames = new String[0];
    private Class<?>[] defaultServiceTypes = new Class[0];
    private int order = 0;
    private AnnotationDescriptor before;
    private AnnotationDescriptor on;
    private AnnotationDescriptor after;

    public HandlerDescriptor(String methodName, MethodHandle methodHandle, int parameterCount) {
        this.methodName = methodName;
        this.methodHandle = methodHandle;
        this.argumentResolvers = new ArrayList<ArgumentResolver>(parameterCount);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public List<ArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers;
    }

    public ReturnResolver getReturnResolver() {
        return this.returnResolver;
    }

    public void setReturnResolver(ReturnResolver returnResolver) {
        this.returnResolver = returnResolver;
    }

    public String[] getDefaultServiceNames() {
        return this.defaultServiceNames;
    }

    public void setDefaultServiceNames(String[] defaultServiceNames) {
        this.defaultServiceNames = defaultServiceNames;
    }

    public Class<?>[] getDefaultServiceTypes() {
        return this.defaultServiceTypes;
    }

    public void setDefaultServiceTypes(Class<?>[] defaultServiceTypes) {
        this.defaultServiceTypes = defaultServiceTypes;
    }

    public void setBefore(Before before) {
        this.before = new AnnotationDescriptor(before);
    }

    public void setOn(On on) {
        this.on = new AnnotationDescriptor(on);
    }

    public void setAfter(After after) {
        this.after = new AnnotationDescriptor(after);
    }

    public List<AnnotationDescriptor> getAnnotations() {
        ArrayList<AnnotationDescriptor> list = new ArrayList<AnnotationDescriptor>();
        if (this.before != null) {
            list.add(this.before);
        }
        if (this.on != null) {
            list.add(this.on);
        }
        if (this.after != null) {
            list.add(this.after);
        }
        return list;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void verifyOrThrow() {
        int eventContextResolverCount = 0;
        int pojoResolverCount = 0;
        for (ArgumentResolver resolver : this.argumentResolvers) {
            resolver.verifyOrThrow(this);
            if (resolver instanceof EventContextArgumentResolver) {
                ++eventContextResolverCount;
            }
            if (!(resolver instanceof PojoArgumentResolver)) continue;
            ++pojoResolverCount;
        }
        if (eventContextResolverCount > 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_ARGUMENT_DUPLICATES, new Object[]{this.getMethodName()});
        }
        if (pojoResolverCount > 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.POJO_ARGUMENT_DUPLICATES, new Object[]{this.getMethodName()});
        }
        this.returnResolver.verifyOrThrow(this);
    }
}

