/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CombinedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> modified;
    private final Map<K, V> basis;

    public CombinedMap(Map<K, V> modified, Map<K, V> basis) {
        this.modified = modified;
        this.basis = basis;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.modified.isEmpty() && this.basis.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.modified.containsKey(key) || this.basis.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.modified.containsValue(value) || this.basis.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.modified.containsKey(key)) {
            return this.modified.get(key);
        }
        return this.basis.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.modified.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.modified.put(key, null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.modified.putAll(m);
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> combined = new HashSet<K>(this.modified.keySet());
        combined.addAll(this.basis.keySet());
        return combined;
    }

    @Override
    public Collection<V> values() {
        return this.entrySet().stream().map(e -> e.getValue()).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> combined = new HashSet<Map.Entry<K, V>>(this.modified.entrySet());
        this.basis.entrySet().stream().filter(e -> !this.modified.keySet().contains(e.getKey())).forEach(combined::add);
        return combined;
    }
}

