/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.ReadStatementAuthorizationModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class InstanceBasedAuthorizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceBasedAuthorizationHandler.class);
    private final boolean authorizeDeeply;
    private final boolean regardCustomEvents;
    private final boolean rejectUnauthorized;

    public InstanceBasedAuthorizationHandler(CdsRuntime runtime) {
        CdsProperties.Security.Authorization authorization = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthorization();
        this.authorizeDeeply = authorization.getDeep().isEnabled();
        this.regardCustomEvents = authorization.getInstanceBased().getCustomEvents().isEnabled();
        this.rejectUnauthorized = authorization.getInstanceBased().getRejectSelectedUnauthorizedEntity().isEnabled();
    }

    @Before(event={"*"})
    @HandlerOrder(value=-10700)
    private void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged()) {
            this.extendStatements(context);
        }
    }

    private void extendStatements(EventContext context) {
        CqnPredicate wherePred;
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        String event = context.getEvent();
        String serviceName = ((ApplicationService)context.getService()).getDefinition().getQualifiedName();
        CdsEntity targetEntity = context.getTarget();
        String entityName = null;
        if (targetEntity != null) {
            entityName = targetEntity.getQualifiedName();
        }
        if (event.equals("READ")) {
            CdsReadEventContext cdsContext = (CdsReadEventContext)context.as(CdsReadEventContext.class);
            if (this.authorizeDeeply) {
                CqnSelect secured = (CqnSelect)CQL.copy((CqnStatement)cdsContext.getCqn(), (Modifier)new ReadStatementAuthorizationModifier(authService, cdsContext));
                if (logger.isDebugEnabled()) {
                    logger.debug("Statement is extended with security conditions for target '{}' of service '{}': '{}'", new Object[]{entityName, serviceName, CqnStatementUtils.anonymizeStatement((CqnStatement)secured)});
                }
                cdsContext.setCqn(secured);
            } else {
                CqnSelect select = cdsContext.getCqn();
                CqnPredicate wherePred2 = authService.calcWhereCondition(entityName, "READ");
                if (wherePred2 != null) {
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
                        wherePred2 = CQL.or((CqnPredicate)wherePred2, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    select = (CqnSelect)CqnUtils.addWhere((CqnStatement)select, (CqnPredicate)wherePred2);
                }
                cdsContext.setCqn(select);
            }
        }
        if (event.equals("DELETE") || event.equals("UPDATE") || event.equals("draftEdit") || event.equals("draftActivate")) {
            wherePred = authService.calcWhereCondition(entityName, event);
            if (wherePred != null) {
                if (this.rejectUnauthorized) {
                    this.checkEntityAuthorization(context, wherePred);
                }
                if (context.getEvent().equals("DELETE")) {
                    CdsDeleteEventContext deleteContext = (CdsDeleteEventContext)context.as(CdsDeleteEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    cqn = (CqnDelete)CqnUtils.addWhere((CqnStatement)deleteContext.getCqn(), (CqnPredicate)wherePred);
                    deleteContext.setCqn(cqn);
                } else if (context.getEvent().equals("UPDATE")) {
                    CdsUpdateEventContext updateContext = (CdsUpdateEventContext)context.as(CdsUpdateEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    cqn = (CqnUpdate)CqnUtils.addWhere((CqnStatement)updateContext.getCqn(), (CqnPredicate)wherePred);
                    updateContext.setCqn((CqnUpdate)cqn);
                } else if (event.equals("draftEdit")) {
                    DraftEditEventContext draftEditContext = (DraftEditEventContext)context.as(DraftEditEventContext.class);
                    cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)draftEditContext.getCqn(), (CqnPredicate)wherePred);
                    draftEditContext.setCqn((CqnSelect)cqn);
                } else if (event.equals("draftActivate")) {
                    DraftSaveEventContext saveContext = (DraftSaveEventContext)context.as(DraftSaveEventContext.class);
                    cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)saveContext.getCqn(), (CqnPredicate)wherePred);
                    saveContext.setCqn((CqnSelect)cqn);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{wherePred.toJson(), entityName, serviceName, event, context.getUserInfo().getName()});
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("No CQN authorization predicate required for entity '{}' of service '{}', event {} and user {}", new Object[]{entityName, serviceName, event, context.getUserInfo().getName()});
            }
        } else if (this.regardCustomEvents && !CdsModelUtils.isStandardCdsEvent(event) && entityName != null && (wherePred = authService.calcWhereCondition(entityName, event)) != null) {
            CqnStatement cqn;
            if (this.rejectUnauthorized) {
                this.checkEntityAuthorization(context, wherePred);
            }
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
            }
            if ((cqn = (CqnStatement)context.get("cqn")) != null && (cqn.isSelect() || cqn.isUpdate() || cqn.isDelete())) {
                context.put("cqn", (Object)CqnUtils.addWhere((CqnStatement)cqn, (CqnPredicate)wherePred));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{wherePred.toJson(), entityName, serviceName, event, context.getUserInfo().getName()});
            }
        }
        logger.debug("Instance-based authorization check passed for event '{}' on service '{}'", (Object)event, (Object)serviceName);
    }

    private void checkEntityAuthorization(EventContext context, CqnPredicate whereCondition) {
        String event = context.getEvent();
        if (!(event.equals("DELETE") || event.equals("UPDATE") || this.regardCustomEvents && !CdsModelUtils.isStandardCdsEvent(event))) {
            return;
        }
        CdsEntity targetEntity = context.getTarget();
        if (targetEntity == null) {
            return;
        }
        Map<String, Object> targetEntityKeys = this.getTargetEntityKeys(context);
        if (Boolean.FALSE.equals(targetEntityKeys.get("IsActiveEntity"))) {
            return;
        }
        Optional<CqnPredicate> keyFilter = this.keysToCondition(targetEntityKeys);
        if (keyFilter.isPresent()) {
            Select read = Select.from((CdsEntity)targetEntity).columns(new Function[]{c -> CQL.val((Object)1).as("FAILED")}).where((CqnPredicate)CQL.and((CqnPredicate)keyFilter.get(), (CqnPredicate)CQL.not((CqnPredicate)whereCondition))).limit(1L);
            long result = CdsServiceUtils.getDefaultPersistenceService(context).run((CqnSelect)read, new Object[0]).rowCount();
            if (result > 0L) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN, new Object[]{event, targetEntity.getQualifiedName()});
            }
        }
    }

    private Map<String, Object> getTargetEntityKeys(EventContext context) {
        CqnFilterableStatement cqn = (CqnFilterableStatement)context.get("cqn");
        if (cqn == null) {
            return Map.of();
        }
        CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
        AnalysisResult analysisResult = analyzer.analyze(cqn);
        return analysisResult.targetKeys();
    }

    private Optional<CqnPredicate> keysToCondition(Map<String, Object> targetKeys) {
        if (targetKeys.isEmpty() || targetKeys.containsValue(null)) {
            return Optional.empty();
        }
        CqnPredicate predicate = (CqnPredicate)targetKeys.entrySet().stream().map(entry -> CQL.get((String)((String)entry.getKey())).eq(entry.getValue())).collect(CQL.withAnd());
        return Optional.of(predicate);
    }
}

