/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.auditlog;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.ConfigChangeLog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.impl.EventContextDelegator;

public class ConfigChangeLogContextImpl extends EventContextDelegator implements ConfigChangeLogContext {
	private static final String PARAM_DATA = "data";
	private static final String PARAM_CREATED_AT = "createdAt";

	public ConfigChangeLogContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public AuditLogService getService() {
		return (AuditLogService) super.getService();
	}

	public ConfigChangeLog getData() {
		return (ConfigChangeLog)get(PARAM_DATA);
	}

	public void setData(ConfigChangeLog event) {
		put(PARAM_DATA, event);
	}

	public Instant getCreatedAt() {
		return (Instant) get(PARAM_CREATED_AT);
	}

	public void setCreatedAt(Instant createdAt) {
		put(PARAM_CREATED_AT, createdAt);
	}
}
