/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.auditlog.events.security;

import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.impl.auditlog.events.AuditEvent;
import com.sap.cds.services.runtime.CdsRuntime;

@CdsName("com.sap.auditlog.events.UnauthorizedRequest")
public interface UnauthorizedRequestEvent extends AuditEvent {

	Event getEvent();

	void setEvent(Event event);

	AuthData getData();

	void setData(AuthData data);

	public static UnauthorizedRequestEvent create(String rejectReason, CdsRuntime runtime) {
		UnauthorizedRequestEvent unauth = Struct.access(
				AuditEvent.create(runtime)).as(UnauthorizedRequestEvent.class);

		AuthData data = AuthData.create();
		data.setMessageId("UNAUTHORIZED_REQUEST");
		data.setMessage("Unauthorized request.");
		data.setRejectReason(rejectReason);
		unauth.setData(data);
		return unauth;
	}
}
