/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.model.Privilege;

public class PredicateLookup {

	private final Map<String, PredicateResolver> cachedPredicatePatterns = new HashMap<>();

	public CqnPredicate resolvePredicate(Privilege privilege, UserInfo user, boolean emptyAttributesAreRestricted) {
		CqnPredicate pred = privilege.getWhereXpr();
		if (pred == null) {
			return null;
		}

		// calculating the pattern is expensive, so reuse cached
		String cxnExpression = privilege.getCxnWhereCondition();
		PredicateResolver cachedPredicatePattern = cachedPredicatePatterns.get(cxnExpression);
		if (cachedPredicatePattern == null) {
			cachedPredicatePattern = PredicateResolver.create(pred, emptyAttributesAreRestricted); // throws on syntax error
			cachedPredicatePatterns.put(cxnExpression, cachedPredicatePattern);
		}

		if (cachedPredicatePattern != null) {
			return cachedPredicatePattern.resolve(user);
		}

		return null;
	}
}
