/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.cds.CqnService;

import java.util.Map;

/**
 * Implementation for specialized {@link EventContext} to be used for {@link CqnService#EVENT_UPSERT}
 */
public class CdsUpsertEventContextImpl extends EventContextDelegator implements CdsUpsertEventContext {

	public CdsUpsertEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public CqnService getService() {
		return (CqnService)super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_RESULT = "result";

	// IN
	public CqnUpsert getCqn() {
		return (CqnUpsert)get(PARAM_CQN);
	}

	public void setCqn(CqnUpsert cqn) {
		put(PARAM_CQN, cqn);
	}

	// OUT
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}
}
