package com.sap.cds.services.impl.outbox.persistence;

import java.util.Collection;
import java.util.List;

import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;

public interface TelemetryData {

	public static final TelemetryData NOOP = new TelemetryData() {};

	default Collection<OutboxStatistics> getStatistics() {
		return List.of();
	}

	default void recordIncomingMessages(String tenant, long count) {
		// NOOP
	}

	default void recordOutgoingMessages(String tenant, long count) {
		// NOOP
	}

	default void recordStatistics(CdsRuntime runtime, PersistenceService db, String tenant) {
		// NOOP
	}
}
