/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.runtime;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;

public class ProviderInfo implements CdsInfo, CdsRuntimeAware {

	private CdsRuntimeImpl runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = (CdsRuntimeImpl) runtime;
	}

	@Override
	public String name() {
		return "providers";
	}

	@Override
	public Map<String, Class<?>> info(Details details) {
		Map<String, Class<?>> providers = new HashMap<>();
		runtime.getProviders().forEach((clazz, provider) -> {
			providers.put(key(clazz), provider.getClass());
		});
		return providers;
	}

	private String key(Class<?> clazz) {
		String simpleName = clazz.getSimpleName();
		if (simpleName.endsWith("Provider")) {
			simpleName = simpleName.substring(0, simpleName.length() - 8);
		}
		if (!simpleName.isEmpty()) {
			simpleName = simpleName.substring(0, 1).toLowerCase(Locale.ENGLISH) + simpleName.substring(1);
		}
		return simpleName;
	}

}
