/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.cds.ApplicationDefaultOnHandler;
import com.sap.cds.services.impl.cds.ApplicationServiceImpl;
import com.sap.cds.services.impl.cds.CapabilitiesHandler;
import com.sap.cds.services.impl.cds.EnumAssertionHandler;
import com.sap.cds.services.impl.cds.FormatAssertionHandler;
import com.sap.cds.services.impl.cds.ImplicitSortingHandler;
import com.sap.cds.services.impl.cds.InstanceBasedAuthorizationHandler;
import com.sap.cds.services.impl.cds.MandatoryHandler;
import com.sap.cds.services.impl.cds.NotNullHandler;
import com.sap.cds.services.impl.cds.RangeAssertionHandler;
import com.sap.cds.services.impl.cds.ReadOnlyHandler;
import com.sap.cds.services.impl.cds.RejectExpandInlineAllHandler;
import com.sap.cds.services.impl.cds.SingletonHandler;
import com.sap.cds.services.impl.cds.StaticAuthorizationHandler;
import com.sap.cds.services.impl.cds.TargetAssertionHandler;
import com.sap.cds.services.impl.cds.ValidationErrorHandler;
import com.sap.cds.services.impl.messaging.message.CdsMessagingUtils;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationServiceConfiguration.class);

    public int order() {
        return 100;
    }

    public static Stream<CdsProperties.Application.ApplicationServiceConfig> applicationServiceConfigs(CdsRuntimeConfigurer configurer, Predicate<? super CdsService> servicePredicate) {
        CdsProperties.Application appConfig = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getApplication();
        ServiceCatalog catalog = configurer.getCdsRuntime().getServiceCatalog();
        return configurer.getCdsRuntime().getCdsModel().services().filter(servicePredicate).map(service -> service.getQualifiedName()).flatMap(name -> {
            List serviceConfigs = appConfig.getServicesByModel(name);
            if (serviceConfigs.isEmpty()) {
                CdsProperties.Application.ApplicationServiceConfig config = appConfig.getService(name);
                if (config.getModel() == null && (appConfig.getServices().values().contains(config) || !catalog.getServices(RemoteService.class).anyMatch(s -> s.getDefinition().getQualifiedName().equals(name)))) {
                    return Stream.of(config);
                }
                return Stream.empty();
            }
            return serviceConfigs.stream();
        }).filter(config -> configurer.getCdsRuntime().getServiceCatalog().getService(config.getName()) == null);
    }

    public void services(CdsRuntimeConfigurer configurer) {
        ApplicationServiceConfiguration.applicationServiceConfigs(configurer, s -> true).map(config -> new ApplicationServiceImpl((CdsProperties.Application.ApplicationServiceConfig)config, configurer.getCdsRuntime())).forEach(arg_0 -> ((CdsRuntimeConfigurer)configurer).service(arg_0));
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        if (configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationService.class).findAny().isPresent()) {
            configurer.eventHandler((Object)new ApplicationDefaultOnHandler()).eventHandler((Object)new CapabilitiesHandler()).eventHandler((Object)new SingletonHandler()).eventHandler((Object)new ReadOnlyHandler()).eventHandler((Object)new MandatoryHandler()).eventHandler((Object)new RangeAssertionHandler()).eventHandler((Object)new FormatAssertionHandler(configurer.getCdsRuntime())).eventHandler((Object)new EnumAssertionHandler()).eventHandler((Object)new ValidationErrorHandler()).eventHandler((Object)new TargetAssertionHandler()).eventHandler((Object)new NotNullHandler()).eventHandler((Object)new RejectExpandInlineAllHandler());
            CdsProperties cdsProperties = configurer.getCdsRuntime().getEnvironment().getCdsProperties();
            if (cdsProperties.getSecurity().getAuthorization().isEnabled().booleanValue()) {
                configurer.eventHandler((Object)new StaticAuthorizationHandler(configurer.getCdsRuntime()));
                configurer.eventHandler((Object)new InstanceBasedAuthorizationHandler(configurer.getCdsRuntime()));
            } else {
                logger.info("*************************************************************************");
                logger.info("*  Generic authorization handler is disabled by the configuration.      *");
                logger.info("*                 !!! NEVER USE IN PRODUCTIVE MODE !!!                  *");
                logger.info("*************************************************************************");
            }
            if (cdsProperties.getQuery().getImplicitSorting().isEnabled().booleanValue()) {
                configurer.eventHandler((Object)new ImplicitSortingHandler());
            }
            Supplier messagingServiceSupplier = Suppliers.memoize(() -> {
                MessagingService messagingService = CdsMessagingUtils.getMessagingService(configurer.getCdsRuntime());
                if (messagingService != null) {
                    logger.info("Configuring event handlers for declared events with target '{}'", (Object)messagingService.getName());
                }
                return messagingService;
            });
            configurer.getCdsRuntime().getServiceCatalog().getServices().filter(s -> s instanceof ApplicationService).map(ApplicationService.class::cast).forEach(arg_0 -> ApplicationServiceConfiguration.lambda$eventHandlers$12((java.util.function.Supplier)messagingServiceSupplier, arg_0));
        }
    }

    private static /* synthetic */ void lambda$eventHandlers$12(java.util.function.Supplier messagingServiceSupplier, ApplicationService applicationService) {
        applicationService.getDefinition().events().forEach(arg_0 -> ApplicationServiceConfiguration.lambda$eventHandlers$11((java.util.function.Supplier)messagingServiceSupplier, applicationService, arg_0));
    }

    private static /* synthetic */ void lambda$eventHandlers$11(java.util.function.Supplier messagingServiceSupplier, ApplicationService applicationService, CdsEvent event) {
        MessagingService messagingService = (MessagingService)messagingServiceSupplier.get();
        if (messagingService != null) {
            String topic = CdsMessagingUtils.getTopic(event);
            logger.debug("Registering outbound event handler for declared event '{}' on application service '{}' targeting messaging service '{}' with topic '{}'", new Object[]{event.getQualifiedName(), applicationService.getName(), messagingService.getName(), topic});
            applicationService.on(event.getName(), null, context -> {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                context.keySet().forEach(key -> headers.put((String)key, context.get(key)));
                Map contextParameters = (Map)headers.computeIfAbsent("cds.context.parameters", k -> new HashMap());
                contextParameters.put("cds.eventName", event.getQualifiedName());
                Map data = (Map)headers.remove("data");
                messagingService.emit(topic, data, headers);
            });
        }
    }
}

