/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.impl.environment.DefaultEnvFileServiceBindingLoader;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.SimpleServiceBindingCache;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultServiceBindingProvider
implements ServiceBindingProvider {
    private static final Object LOCK = new Object();
    private final CdsRuntime runtime;
    private List<ServiceBinding> bindings;

    public DefaultServiceBindingProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Stream<ServiceBinding> get() {
        if (this.bindings == null) {
            this.bindings = this.loadBindings();
        }
        return this.bindings.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceBinding> loadBindings() {
        Object object = LOCK;
        synchronized (object) {
            ServiceBindingAccessor accessor = DefaultServiceBindingAccessor.getInstance();
            if (accessor instanceof SimpleServiceBindingCache) {
                SimpleServiceBindingCache cache = (SimpleServiceBindingCache)accessor;
                cache.invalidate();
            }
            DefaultEnvFileServiceBindingLoader.configuredPath = this.runtime.getEnvironment().getCdsProperties().getEnvironment().getLocal().getDefaultEnvPath();
            return accessor.getServiceBindings().stream().collect(Collectors.toList());
        }
    }
}

