/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.collectors.TenantCache;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class PersistentOutboxInitializationHandler
implements EventHandler {
    private final TenantCache tenantCache;

    public PersistentOutboxInitializationHandler(TenantCache tenantCache) {
        this.tenantCache = tenantCache;
    }

    @After
    protected void initOutboxCollectors(ApplicationPreparedEventContext context) {
        if (context.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            return;
        }
        this.tenantCache.start(context.getCdsRuntime());
        context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::init);
    }

    @On
    protected void stopOutboxCollectors(ApplicationStoppedEventContext context) {
        context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::stop);
        this.tenantCache.stop();
    }
}

