/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl;

import java.util.stream.Stream;

import com.sap.cds.services.Service;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;

public interface ServiceSPI extends Service {

	/**
	 * Makes the {@link CdsRuntime} known to the {@link Service}
	 * @param runtime the {@link CdsRuntime}
	 */
	void setCdsRuntime(CdsRuntime runtime);

	/**
	 * Returns the {@link CdsRuntime} this {@link Service} belongs to.
	 *
	 * @return	The {@link CdsRuntime} instance.
	 */
	CdsRuntime getCdsRuntime();

	/**
	 * Makes the delegator (e.g a typed proxy instance) known to the {@link Service}
	 * @param delegator the delegator {@link Service}
	 */
	void setDelegator(Service delegator);

	/**
	 * Sets the outbox that shall be called for the next emit.
	 *
	 * @param outboxService the outbox service
	 */
	void setOutbox(OutboxService outboxService);

	/**
	 * An entity describing a handler registration for this service.
	 */
	public interface HandlerRegistration {
		/**
		 * @return	The {@link EventPredicate} describing the matching events and CDS entities
		 */
		EventPredicate getEventPredicate();

		/**
		 * @return	The handler
		 */
		Handler getHandler();

		/**
		 * @return	The order of the handler
		 */
		int getOrder();
	}

	/**
	 * Provides a {@link Stream} of {@link HandlerRegistration}s for the given {@link Phase}.
	 *
	 * @param phase	The phase the registrations refer to
	 * @return	The stream
	 */
	Stream<HandlerRegistration> registrations(Phase phase);
}
